/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.applicationproperties;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinition;
import com.sap.ide.webdynpro.applicationeditor.EditUI;
import com.sap.ide.webdynpro.applicationeditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.applicationeditor.wizards.applicationproperty.CreateApplicationPropertyWizardData;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceWithUI;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.applicationproperty.ApplicationPropertyService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ApplicationPropertyEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Application mApplication = null;
    private CreateApplicationPropertyWizardData mData = null;
    private int mMode;
    private int mPropertyType = -1;
    public static final int PROPERTY_TYPE_PREDEFINED = 0;
    public static final int PROPERTY_TYPE_SELFDEFINED = 1;
    private Text mNameField = null;
    private Button mSelectNameButton = null;
    private Combo mValueField = null;
    private Text mDescriptionField = null;

    public ApplicationPropertyEditUI(CreateApplicationPropertyWizardData data, int mode, int propertyType, Application application, IDisplayErrorListener displayErrorListener) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mPropertyType = propertyType;
        this.mApplication = application;
    }

    public void initUI(IGridLayoutPane glp) {
        IGridLayoutData gd = null;
        glp.addTextLabel(mTextPool.getText(121));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), true, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mSelectNameButton = glp.addPushButton(mTextPool.getText(105));
        this.mSelectNameButton.addSelectionListener((SelectionListener)new SelectNameButtonListener());
        glp.addTextLabel(mTextPool.getText(122));
        gd = glp.createGridLayoutData(4, 4, true, false);
        String[] values = new String[]{};
        String value = this.mData.getValue();
        this.mValueField = glp.addComboBox(values, value, false, gd);
        this.configureValueComboBox();
        this.mValueField.addModifyListener((ModifyListener)new ValueModifyListener());
        this.mValueField.setFocus();
        glp.addPlaceholder();
        glp.addTextLabel(mTextPool.getText(144));
        gd = glp.createGridLayoutData(4, 4, true, false, 2, 2);
        this.mDescriptionField = glp.addTextPane("", true, true, gd);
        if (this.mPropertyType == 0) {
            if (this.mData.getDefinition() != null) {
                this.mDescriptionField.setText(this.mData.getDefinition().getDescription());
            }
        } else {
            this.mDescriptionField.setText(mTextPool.getText(143));
        }
        this.getDisplayErrorListener().setPageComplete(false);
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1 && this.mData.getDefinition() == null) {
            error = ApplicationPropertyService.isNewNameValid((String)this.mNameField.getText(), (Application)this.mApplication);
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        error = ApplicationPropertyService.isNewValueValid((String)this.mValueField.getText(), (Application)this.mApplication, (ApplicationPropertyDefinition)this.mData.getDefinition());
        this.getDisplayErrorListener().setErrorMessage(error);
        return error == null;
    }

    public void setApplicationPropertyType(int type) {
        this.mPropertyType = type;
        if (type == 0) {
            this.mNameField.setEditable(false);
            this.mNameField.setText("");
            if (this.mData.getDefinition() != null) {
                this.mDescriptionField.setText(this.mData.getDefinition().getDescription());
            } else {
                this.mDescriptionField.setText("");
            }
            this.mData.setName("");
            this.mSelectNameButton.setEnabled(true);
        } else {
            this.mNameField.setEditable(this.mMode != 1);
            this.mNameField.setText("");
            this.mData.setName("");
            this.mData.setDefinition(null);
            this.mDescriptionField.setText(mTextPool.getText(143));
            this.mSelectNameButton.setEnabled(false);
        }
        this.configureValueComboBox();
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private void configureValueComboBox() {
        String[] validValues = null;
        validValues = this.mData.getDefinition() != null ? (this.mData.getDefinition().getType().getName().equals("boolean") ? ApplicationPropertyService.VALUES_BOOLEAN : new String[]{}) : new String[]{};
        this.mValueField.setItems(validValues);
        int index = this.mValueField.indexOf(this.mData.getValue());
        if (index != -1) {
            this.mValueField.select(index);
        } else {
            this.mValueField.clearSelection();
            this.mValueField.setText(this.mData.getValue());
        }
    }

    private class ApplicationPropertyDefinitionFilter
    implements DevelopmentObjectFilter {
        private ApplicationPropertyDefinitionFilter() {
        }

        public boolean isValidObject(DevelopmentObject object) {
            return true;
        }
    }

    private class ValueModifyListener
    implements ModifyListener {
        private ValueModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ApplicationPropertyEditUI.this.validatePage();
            ApplicationPropertyEditUI.this.mData.setValue(ApplicationPropertyEditUI.this.mValueField.getText());
        }
    }

    private class SelectNameButtonListener
    implements SelectionListener {
        private SelectNameButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ApplicationPropertyDefinition definition = ServiceWithUI.selectApplicationPropertyDefinition((DevelopmentObjectFilter)new ApplicationPropertyDefinitionFilter(), (MainDevelopmentObject)ApplicationPropertyEditUI.this.mApplication);
            if (definition != null) {
                ApplicationPropertyEditUI.this.mData.setDefinition(definition);
                ApplicationPropertyEditUI.this.mData.setName(definition.getQualifiedName());
                String defaultValue = "";
                if (definition.getDefaultValue() != null) {
                    defaultValue = definition.getDefaultValue();
                }
                ApplicationPropertyEditUI.this.mData.setValue(defaultValue);
                ApplicationPropertyEditUI.this.mNameField.setText(ApplicationPropertyEditUI.this.mData.getName());
                ApplicationPropertyEditUI.this.mValueField.setText(ApplicationPropertyEditUI.this.mData.getValue());
                ApplicationPropertyEditUI.this.mDescriptionField.setText(definition.getDescription());
                ApplicationPropertyEditUI.this.configureValueComboBox();
            }
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ApplicationPropertyEditUI.this.validatePage();
            ApplicationPropertyEditUI.this.mData.setName(ApplicationPropertyEditUI.this.mNameField.getText());
        }
    }
}

