/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor.applicationproperties;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.ApplicationProperty;
import com.sap.ide.webdynpro.applicationeditor.AbstractApplicationTableModel;
import com.sap.ide.webdynpro.applicationeditor.Plugin;
import com.sap.ide.webdynpro.applicationeditor.applicationproperties.ApplicationPropertyEditDialog;
import com.sap.ide.webdynpro.applicationeditor.wizards.applicationproperty.CreateApplicationPropertyWizardDialog;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.applicationproperty.ApplicationPropertyService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.Arrays;

public class ApplicationPropertiesTableModel
extends AbstractApplicationTableModel {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS = 3;
    private static final String[] COLUMN_NAMES = new String[]{mTextPool.getText(118), mTextPool.getText(119), mTextPool.getText(142)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ApplicationPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ApplicationPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ApplicationPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_VALUE = 1;
    private static final int COLUMN_DESCRIPTION = 2;
    private ApplicationProperty[] mProperties = null;
    static /* synthetic */ Class class$java$lang$String;

    public ApplicationPropertiesTableModel(Application application) {
        super(application);
        this.setNumberOfColumns(3);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mProperties.length) {
            return null;
        }
        return this.mProperties[index];
    }

    protected void updateDataTable() {
        if (this.getApplication() != null) {
            this.mProperties = this.getApplication().getApplicationProperties();
            Arrays.sort(this.mProperties, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mProperties == null) {
            return 0;
        }
        return this.mProperties.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mProperties.length <= rowIndex) {
            return AbstractApplicationTableModel.ERROR;
        }
        ApplicationProperty property = this.mProperties[rowIndex];
        if (property == null) {
            return AbstractApplicationTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return property.getName();
            }
            case 1: {
                return property.getValue();
            }
            case 2: {
                if (property.hasPropertyDefinition()) {
                    return property.getPropertyDefinition().getDescription();
                }
                return mTextPool.getText(143);
            }
        }
        return AbstractApplicationTableModel.ERROR;
    }

    protected void doCopy(int[] indexes) {
    }

    protected void doDelete(int[] indexes) {
        ApplicationProperty[] properties = this.getIndexesProperties(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < properties.length) {
            ApplicationProperty property = properties[i];
            MMRepositoryObject[] repositoryObjects = ApplicationPropertyService.getRepositoryObjectsAffectedByApplicationPropertyDeletion((ApplicationProperty)property);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)property.getName(), (String)mTextPool.getText(125))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                try {
                    property.delete();
                }
                catch (DeleteException de) {
                    Plugin.internalError(this.getClass(), "doDelete", de.getMessage(), de, false);
                }
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        ApplicationProperty[] properties = this.getIndexesProperties(indexes);
        int i = 0;
        while (i < properties.length) {
            ApplicationProperty property = properties[i];
            MMRepositoryObject[] repositoryObjects = ApplicationPropertyService.getRepositoryObjectsAffectedByApplicationPropertyDeletion((ApplicationProperty)property);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ApplicationPropertyEditDialog dialog = new ApplicationPropertyEditDialog(property, 1);
            if (dialog.open() == 0 && !dialog.getNewValue().equals(property.getValue())) {
                property.setValue(dialog.getNewValue());
            }
            ++i;
        }
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = ApplicationPropertyService.getRepositoryObjectsAffectedByApplicationPropertyCreation((Application)this.getApplication());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateApplicationPropertyWizardDialog dialog = new CreateApplicationPropertyWizardDialog(this.getApplication());
        dialog.open();
        dialog.close();
    }

    public boolean isCopyable(int[] indexes) {
        return false;
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof ApplicationProperty) {
            switch (event.getEventId()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isReadOnly() {
        return this.getApplication().originatesInArchive();
    }

    private ApplicationProperty[] getIndexesProperties(int[] indexes) {
        ApplicationProperty[] properties = new ApplicationProperty[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            properties[i] = this.mProperties[indexes[i]];
            ++i;
        }
        return properties;
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        return false;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        ApplicationProperty[] properties = this.getIndexesProperties(indexes);
        clipboard.copy((DevelopmentObject[])properties);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
    }

    protected void doRename(int[] indexes) {
    }

    public boolean isCutable(int[] indexes) {
        return false;
    }

    public boolean isPasteable() {
        return false;
    }

    public boolean isRenameable(int[] indexes) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

