/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.webdynpro.applicationeditor.ApplicationEditorContributor;
import com.sap.ide.webdynpro.applicationeditor.Plugin;
import com.sap.ide.webdynpro.applicationeditor.applicationproperties.ApplicationPropertiesPage;
import com.sap.ide.webdynpro.applicationeditor.overview.OverviewPage;
import com.sap.ide.webdynpro.service.applicationeditor.ApplicationEditorInput;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.file.FileFindService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ApplicationEditorPart
extends MultiPageEditorPart
implements DevelopmentObjectObserver,
IMetamodelSaveParticipant,
IDevelopmentObjectEditor {
    private static final TextPool mTextPool = TextPool.getInstance();
    private Application mApplication = null;
    private int mActivePage = -2;
    private ApplicationEditorPartListener mApplicationEditorPartListener = null;
    private int mOverviewTabIndex = -1;
    private int mPropertiesTabIndex = -1;
    private int mRequestedTab = -1;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof ApplicationEditorInput) {
            ApplicationEditorInput input = (ApplicationEditorInput)editorInput;
            this.mApplication = input.getApplication();
        } else if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            if (fileEditorInput.getFile() == null) {
                throw new PartInitException(mTextPool.getText(0, (Object)"No file given"));
            }
            String projectName = fileEditorInput.getFile().getProject().getName();
            if (!ServicesEclipse.projectHasWebDynproNature((String)projectName)) {
                throw new PartInitException("The project '" + projectName + "' has no Web Dynpro nature");
            }
            WebDynproRoot root = MetamodelServices.getWebDynproRoot((String)projectName);
            Application[] applications = null;
            try {
                applications = root.getApplications();
            }
            catch (LoadException e) {
                Plugin.internalError(((Object)((Object)this)).getClass(), "init(IEditorSite, IEditorInput)", e.getMessage(), e, false);
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
            IFile file = fileEditorInput.getFile();
            this.mApplication = FileFindService.isApplicationEditorMetadataFile((IFile)file, (Application[])applications);
            if (this.mApplication == null) {
                throw new PartInitException(mTextPool.getText(0, (Object)file.getLocation()));
            }
            ApplicationEditorInput input = null;
            input = new ApplicationEditorInput(this.mApplication);
            this.mApplication = input.getApplication();
            editorInput = input;
        } else {
            throw new PartInitException(mTextPool.getText(0, (Object)editorInput.getClass().getName()));
        }
        super.init(site, editorInput);
        this.mApplication.attachObserver((DevelopmentObjectObserver)this);
        this.mApplication.attachChildrenObserver((DevelopmentObjectObserver)this);
        String editorName = this.mApplication.getName();
        this.setTitle(editorName);
        this.setTitleImage(SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_APPLICATION));
        this.mApplicationEditorPartListener = new ApplicationEditorPartListener(this);
        this.getSite().getPage().addPartListener((IPartListener)this.mApplicationEditorPartListener);
    }

    protected void createPages() {
        this.createOverviewPage();
        this.createApplicationPropertiesPage();
        this.setInitialTab();
    }

    private void setInitialTab() {
        this.setActivePage(this.mOverviewTabIndex);
        this.pageChange(this.mOverviewTabIndex);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void createOverviewPage() {
        OverviewPage page = new OverviewPage(this.mApplication);
        this.mOverviewTabIndex = this.addPage((Control)page.init(this.getContainer()));
        this.setPageText(this.mOverviewTabIndex, mTextPool.getText(109));
    }

    private void createApplicationPropertiesPage() {
        ApplicationPropertiesPage page = new ApplicationPropertiesPage(this.mApplication);
        this.mPropertiesTabIndex = this.addPage((Control)page.init(this.getContainer()));
        this.setPageText(this.mPropertiesTabIndex, mTextPool.getText(115));
    }

    public void update(MetamodelEvent[] events) {
        boolean updateNecessary = false;
        int i = 0;
        while (i < events.length) {
            updateNecessary = true;
            ++i;
        }
        if (updateNecessary) {
            // empty if block
        }
    }

    public void update(MetamodelEvent event) {
        MetamodelEvent[] events = new MetamodelEvent[]{event};
        this.update(events);
    }

    public void dispose() {
        this.mApplication.detachObserver((DevelopmentObjectObserver)this);
        this.mApplication.detachChildrenObserver((DevelopmentObjectObserver)this);
        this.getSite().getPage().removePartListener((IPartListener)this.mApplicationEditorPartListener);
        super.dispose();
    }

    public void postSave() {
    }

    public void preSave() {
    }

    public Metamodel getMetamodel() {
        if (this.mApplication != null) {
            return this.mApplication.getRoot().getMetamodel();
        }
        return null;
    }

    public void postRollback() {
        this.updateUI();
    }

    public void setFocus() {
        super.setFocus();
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof ApplicationEditorContributor) {
            if (this.mApplication.isReadOnly()) {
                ((ApplicationEditorContributor)contributor).setReadOnlyText(mTextPool.getText(133));
            } else {
                ((ApplicationEditorContributor)contributor).setReadOnlyText(mTextPool.getText(134));
            }
        }
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.mApplication;
    }

    public void updateUI() {
        int i = 0;
        while (i < this.getPageCount()) {
            this.getControl(i).redraw();
            this.getControl(i).update();
            ++i;
        }
    }

    private class ApplicationEditorPartListener
    implements IPartListener {
        private ApplicationEditorPart mApplicationEditorPart = null;

        public ApplicationEditorPartListener(ApplicationEditorPart applicationEditorPart) {
            this.mApplicationEditorPart = applicationEditorPart;
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

