/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.applicationeditor.AbstractApplicationTableModel;
import com.sap.ide.webdynpro.applicationeditor.ContextMenuProvider;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.glpc.section.TableSection;
import com.tssap.util.ui.pane.IGridLayoutPane;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractApplicationTableSection
extends TableSection
implements DisposeListener,
SelectionListener {
    protected static final TextPool mTextPool = TextPool.getInstance();
    protected static final int BUTTON_INDEX_NEW_OR_ADD = 0;
    protected static final String[] BUTTONS_NEW = new String[]{mTextPool.getText(1000)};
    protected static final String[] BUTTONS_ADD = new String[]{mTextPool.getText(1001)};
    private Application mApplication = null;
    private AbstractApplicationTableModel mTableModel = null;
    private ContextMenuProvider mContextMenuProvider = null;

    public AbstractApplicationTableSection(Application application, AbstractApplicationTableModel tableModel, String title, String description, String[] buttons) {
        this(application, tableModel, title, description, buttons, null);
    }

    public AbstractApplicationTableSection(Application application, AbstractApplicationTableModel tableModel, String title, String description, String[] buttons, boolean[] buttonsEnabled) {
        super((TableModel)tableModel, ServiceCorePlugin.WIDGET_FACTORY, title, description, buttons, buttonsEnabled, false);
        this.mApplication = application;
        this.mTableModel = tableModel;
        this.addButtonClickedListener(new ButtonClickedListener());
        this.mContextMenuProvider = new ContextMenuProvider(this);
        this.addMenuProvider(this.mContextMenuProvider);
    }

    protected Application getApplication() {
        return this.mApplication;
    }

    public void update(DevelopmentObject newMasterObject) {
        if (newMasterObject != null) {
            this.setButtonEnabled(0, true);
        } else {
            this.setButtonEnabled(0, false);
        }
    }

    public void enableDisableButtons() {
        this.setButtonEnabled(0, !this.mTableModel.isReadOnly());
    }

    public void widgetDisposed(DisposeEvent e) {
        this.mTableModel.tableModelDisposed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        super.widgetDefaultSelected(e);
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget instanceof Table) {
            Table table = (Table)e.widget;
            this.mTableModel.selectionChanged(table.getSelectionIndices());
        }
    }

    protected void postInitSection(IGridLayoutPane glp) {
        super.postInitSection(glp);
        this.getUserAreaGridLayoutPane().addDisposeListener((DisposeListener)this);
        this.addSelectionListener(this);
        this.setButtonEnabled(0, !this.mTableModel.isReadOnly());
    }

    public ContextMenuProvider getContextMenuProvider() {
        return this.mContextMenuProvider;
    }

    private class ButtonClickedListener
    implements IButtonClickedListener {
        private ButtonClickedListener() {
        }

        public void buttonClicked(ButtonClickedEvent e) {
            switch (e.getIndex()) {
                case 0: {
                    AbstractApplicationTableSection.this.mTableModel.doNew();
                    break;
                }
            }
        }
    }
}

