/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.applicationeditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.applicationeditor.AbstractApplicationTableSection;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.core.ReadonlyStateChangedEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractApplicationTableModel
extends AbstractTableModel
implements DevelopmentObjectObserver {
    protected static final TextPool mTextPool = TextPool.getInstance();
    public static final String ERROR = mTextPool.getText(3);
    private Application mApplication = null;
    private int mNumberOfColumns = 0;
    private String[] mColumnNames = new String[0];
    private Class[] mColumnClasses = new Class[0];
    private HashMap mDetailTableModels = new HashMap();
    protected int[] mSelectionIndexes = new int[0];
    private AbstractApplicationTableSection mTableSection = null;

    public AbstractApplicationTableModel(Application application) {
        this.mApplication = application;
        this.mApplication.attachChildrenObserver((DevelopmentObjectObserver)this);
    }

    public void setTableSection(AbstractApplicationTableSection tableSection) {
        this.mTableSection = tableSection;
    }

    public void addDetailTableModel(AbstractApplicationTableModel tableModel) {
        if (this.mDetailTableModels.get(tableModel.getInternalName()) == null) {
            this.mDetailTableModels.put(tableModel.getInternalName(), tableModel);
        }
    }

    public void removeDetailTableModel(AbstractApplicationTableModel tableModel) {
        this.mDetailTableModels.remove(tableModel.getInternalName());
    }

    protected Application getApplication() {
        return this.mApplication;
    }

    protected String getInternalName() {
        return this.getClass().getName();
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        this.mSelectionIndexes = new int[0];
        this.updateDataTable();
        this.fireTableDataChanged();
        this.mTableSection.update(newMasterObject);
    }

    protected abstract void updateDataTable();

    public abstract DevelopmentObject getDataTableEntry(int var1);

    public void selectionChanged(int[] newSelections) {
        this.mSelectionIndexes = new int[newSelections.length];
        int i = 0;
        while (i < newSelections.length) {
            this.mSelectionIndexes[i] = newSelections[i];
            ++i;
        }
        if (this.mSelectionIndexes.length == 1) {
            DevelopmentObject selectedObject = null;
            if (this.mSelectionIndexes[0] > -1) {
                selectedObject = this.getDataTableEntry(this.mSelectionIndexes[0]);
            }
            Iterator it = this.mDetailTableModels.values().iterator();
            while (it.hasNext()) {
                AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)it.next();
                tableModel.masterObjectChanged(selectedObject);
            }
        } else {
            Iterator it = this.mDetailTableModels.values().iterator();
            while (it.hasNext()) {
                AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)it.next();
                tableModel.masterObjectChanged(null);
            }
        }
    }

    protected void doCallCut(int[] indexes) {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        clipboard.clear();
        this.doCut(clipboard, indexes);
    }

    protected void doCut(MetamodelClipboard clipboard, int[] indexes) {
        this.doCopy(clipboard, indexes);
        this.doDelete(indexes);
    }

    protected void doCallCopy(int[] indexes) {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        clipboard.clear();
        this.doCopy(clipboard, indexes);
    }

    protected void doCallPaste() {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        this.doPaste(clipboard);
    }

    protected abstract boolean canPaste(MetamodelClipboard var1);

    protected abstract void doNew();

    protected abstract void doEdit(int[] var1);

    protected abstract void doCopy(MetamodelClipboard var1, int[] var2);

    protected abstract void doPaste(MetamodelClipboard var1);

    protected abstract void doRename(int[] var1);

    protected abstract void doDelete(int[] var1);

    protected void setNumberOfColumns(int numberOfColumns) {
        this.mNumberOfColumns = numberOfColumns;
    }

    protected void setColumnNames(String[] columnNames) {
        this.mColumnNames = columnNames;
    }

    protected void setColumnClasses(Class[] columnClasses) {
        this.mColumnClasses = columnClasses;
    }

    public abstract int getRowCount();

    public int getColumnCount() {
        return this.mNumberOfColumns;
    }

    public String getColumnName(int columnIndex) {
        return this.mColumnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return this.mColumnClasses[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public abstract Object getValueAt(int var1, int var2);

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void update(MetamodelEvent event) {
        MetamodelEvent[] events = new MetamodelEvent[]{event};
        this.update(events);
    }

    public void update(MetamodelEvent[] events) {
        boolean updateNecessary = false;
        boolean uiUpdateNecessary = false;
        int i = 0;
        while (i < events.length) {
            if (events[i].getEventId() == 8192 || this.isEventRelevant(events[i])) {
                updateNecessary = true;
            } else if (events[i].getEventId() == 32768 && events[i] instanceof ReadonlyStateChangedEvent) {
                uiUpdateNecessary = true;
            }
            ++i;
        }
        if (updateNecessary) {
            this.updateDataTable();
            if (this.mSelectionIndexes.length == 1 && this.mSelectionIndexes[0] >= this.getRowCount()) {
                this.mSelectionIndexes[0] = -1;
                DevelopmentObject selectedObject = null;
                Iterator it = this.mDetailTableModels.values().iterator();
                while (it.hasNext()) {
                    AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)it.next();
                    tableModel.masterObjectChanged(selectedObject);
                }
            }
            this.fireTableDataChanged();
        }
        if (uiUpdateNecessary && this.mTableSection != null) {
            this.mTableSection.enableDisableButtons();
        }
    }

    protected abstract boolean isEventRelevant(MetamodelEvent var1);

    public void tableModelDisposed() {
        this.mApplication.detachChildrenObserver((DevelopmentObjectObserver)this);
    }

    public boolean isEditable(int[] indexes) {
        return !this.isReadOnly() && this.isObjectSelected() && this.isSingleObjectSelected();
    }

    public boolean isCutable(int[] indexes) {
        return !this.isReadOnly() && this.isObjectSelected();
    }

    public boolean isCopyable(int[] indexes) {
        return this.isObjectSelected();
    }

    public boolean isPasteable() {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        return !this.isReadOnly() && clipboard.isPasteAllowed((MetamodelObject)this.getApplication()) && this.canPaste(clipboard);
    }

    public boolean isRenameable(int[] indexes) {
        return !this.isReadOnly() && this.isObjectSelected() && this.isSingleObjectSelected();
    }

    public boolean isDeletable(int[] indexes) {
        return !this.isReadOnly() && this.isObjectSelected();
    }

    public boolean isObjectSelected() {
        int[] selectionIndexes = this.mTableSection.getTableViewer().getTable().getSelectionIndices();
        return selectionIndexes != null && selectionIndexes.length != 0;
    }

    public boolean isSingleObjectSelected() {
        int[] selectionIndexes = this.mTableSection.getTableViewer().getTable().getSelectionIndices();
        return selectionIndexes != null && selectionIndexes.length == 1;
    }

    protected abstract boolean isReadOnly();
}

