/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.event.GraphicsNodeChangeEvent;
import org.apache.batik.gvt.event.GraphicsNodeChangeListener;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.gvt.filter.GraphicsNodeRable8Bit;
import org.apache.batik.gvt.filter.Mask;

public abstract class AbstractGraphicsNode
implements GraphicsNode {
    protected EventListenerList listeners;
    protected AffineTransform transform;
    protected AffineTransform inverseTransform;
    protected Composite composite;
    protected boolean isVisible = true;
    protected ClipRable clip;
    protected RenderingHints hints;
    protected CompositeGraphicsNode parent;
    protected RootGraphicsNode root;
    protected Mask mask;
    protected Filter filter;
    protected int pointerEventType = 0;
    protected WeakReference graphicsNodeRable;
    protected WeakReference enableBackgroundGraphicsNodeRable;
    protected WeakReference weakRef;
    private Rectangle2D bounds;
    protected GraphicsNodeChangeEvent changeStartedEvent = null;
    protected GraphicsNodeChangeEvent changeCompletedEvent = null;

    protected AbstractGraphicsNode() {
    }

    public WeakReference getWeakReference() {
        if (this.weakRef == null) {
            this.weakRef = new WeakReference<AbstractGraphicsNode>(this);
        }
        return this.weakRef;
    }

    public int getPointerEventType() {
        return this.pointerEventType;
    }

    public void setPointerEventType(int n) {
        this.pointerEventType = n;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.transform = affineTransform;
        if (this.transform.getDeterminant() != 0.0) {
            try {
                this.inverseTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
        } else {
            this.inverseTransform = this.transform;
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    public AffineTransform getGlobalTransform() {
        AffineTransform affineTransform = new AffineTransform();
        AbstractGraphicsNode abstractGraphicsNode = this;
        while (abstractGraphicsNode != null) {
            if (abstractGraphicsNode.getTransform() != null) {
                affineTransform.preConcatenate(abstractGraphicsNode.getTransform());
            }
            abstractGraphicsNode = abstractGraphicsNode.getParent();
        }
        return affineTransform;
    }

    public void setComposite(Composite composite) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.composite = composite;
        this.fireGraphicsNodeChangeCompleted();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setVisible(boolean bl) {
        this.fireGraphicsNodeChangeStarted();
        this.isVisible = bl;
        this.fireGraphicsNodeChangeCompleted();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setClip(ClipRable clipRable) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.clip = clipRable;
        this.fireGraphicsNodeChangeCompleted();
    }

    public ClipRable getClip() {
        return this.clip;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.fireGraphicsNodeChangeStarted();
        if (this.hints == null) {
            this.hints = new RenderingHints(key, object);
        } else {
            this.hints.put(key, object);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public void setRenderingHints(Map map) {
        this.fireGraphicsNodeChangeStarted();
        if (this.hints == null) {
            this.hints = new RenderingHints(map);
        } else {
            this.hints.putAll((Map<?, ?>)map);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.fireGraphicsNodeChangeStarted();
        this.hints = renderingHints;
        this.fireGraphicsNodeChangeCompleted();
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setMask(Mask mask) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.mask = mask;
        this.fireGraphicsNodeChangeCompleted();
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setFilter(Filter filter) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.filter = filter;
        this.fireGraphicsNodeChangeCompleted();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Filter getGraphicsNodeRable(boolean bl) {
        GraphicsNodeRable graphicsNodeRable = null;
        if (this.graphicsNodeRable != null && (graphicsNodeRable = (GraphicsNodeRable)this.graphicsNodeRable.get()) != null) {
            return graphicsNodeRable;
        }
        if (bl) {
            graphicsNodeRable = new GraphicsNodeRable8Bit(this);
            this.graphicsNodeRable = new WeakReference<GraphicsNodeRable>(graphicsNodeRable);
        }
        return graphicsNodeRable;
    }

    public Filter getEnableBackgroundGraphicsNodeRable(boolean bl) {
        GraphicsNodeRable graphicsNodeRable = null;
        if (this.enableBackgroundGraphicsNodeRable != null && (graphicsNodeRable = (GraphicsNodeRable)this.enableBackgroundGraphicsNodeRable.get()) != null) {
            return graphicsNodeRable;
        }
        if (bl) {
            graphicsNodeRable = new GraphicsNodeRable8Bit(this);
            graphicsNodeRable.setUsePrimitivePaint(false);
            this.enableBackgroundGraphicsNodeRable = new WeakReference<GraphicsNodeRable>(graphicsNodeRable);
        }
        return graphicsNodeRable;
    }

    public void paint(Graphics2D graphics2D) {
        Cloneable cloneable;
        Object object;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.composite != null && this.composite instanceof AlphaComposite && (double)((AlphaComposite)(object = (AlphaComposite)this.composite)).getAlpha() < 0.001) {
            return;
        }
        object = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        AffineTransform affineTransform = graphics2D.getTransform();
        RenderingHints renderingHints = null;
        if (this.hints != null) {
            renderingHints = graphics2D.getRenderingHints();
            graphics2D.addRenderingHints(this.hints);
        }
        if (this.transform != null) {
            graphics2D.transform(this.transform);
        }
        if (this.composite != null) {
            graphics2D.setComposite(this.composite);
        }
        if (this.clip != null) {
            graphics2D.clip(this.clip.getClipPath());
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, shape);
        boolean bl = true;
        Rectangle2D rectangle2D = this.getBounds();
        Shape shape2 = shape;
        if (shape2 != null) {
            cloneable = shape2.getBounds2D();
            if (rectangle2D != null && !rectangle2D.intersects(((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight())) {
                bl = false;
            }
        }
        if (bl) {
            cloneable = graphics2D.getTransform();
            boolean bl2 = false;
            if (this.clip != null) {
                bl2 = false;
            }
            boolean bl3 = this.isOffscreenBufferNeeded();
            if (!(bl3 |= bl2)) {
                this.primitivePaint(graphics2D);
            } else {
                Filter filter = null;
                filter = this.filter == null ? this.getGraphicsNodeRable(true) : this.filter;
                if (this.mask != null) {
                    if (this.mask.getSource() != filter) {
                        this.mask.setSource(filter);
                    }
                    filter = this.mask;
                }
                if (this.clip != null && bl2) {
                    if (this.clip.getSource() != filter) {
                        this.clip.setSource(filter);
                    }
                    filter = this.clip;
                }
                if (bl2) {
                    graphics2D.setClip(null);
                }
                Rectangle2D rectangle2D2 = filter.getBounds2D();
                graphics2D.clip(rectangle2D2);
                GraphicsUtil.drawImage((Graphics2D)graphics2D, (RenderableImage)filter);
            }
        }
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip((Shape)object);
        if (this.composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    private void traceFilter(Filter filter, String string) {
        System.out.println(string + filter.getClass().getName());
        System.out.println(string + filter.getBounds2D());
        Vector<RenderableImage> vector = filter.getSources();
        int n = vector != null ? vector.size() : 0;
        string = string + "\t";
        int n2 = 0;
        while (n2 < n) {
            Filter filter2 = (Filter)vector.elementAt(n2);
            this.traceFilter(filter2, string);
            ++n2;
        }
        System.out.flush();
    }

    protected boolean isOffscreenBufferNeeded() {
        return this.filter != null || this.mask != null || this.composite != null && !AlphaComposite.SrcOver.equals(this.composite);
    }

    protected boolean isAntialiasedClip(AffineTransform affineTransform, RenderingHints renderingHints, Shape shape) {
        boolean bl = false;
        if (!(renderingHints.get(RenderingHints.KEY_ANTIALIASING) != RenderingHints.VALUE_ANTIALIAS_ON && renderingHints.get(RenderingHints.KEY_RENDERING) != RenderingHints.VALUE_RENDER_QUALITY || shape instanceof Rectangle2D && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0)) {
            bl = true;
        }
        return bl;
    }

    public void fireGraphicsNodeChangeStarted() {
        RootGraphicsNode rootGraphicsNode;
        if (this.changeStartedEvent == null) {
            this.changeStartedEvent = new GraphicsNodeChangeEvent(this, 9800);
        }
        if ((rootGraphicsNode = this.getRoot()) == null) {
            return;
        }
        List list = rootGraphicsNode.getTreeGraphicsNodeChangeListeners();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GraphicsNodeChangeListener graphicsNodeChangeListener = (GraphicsNodeChangeListener)iterator.next();
            graphicsNodeChangeListener.changeStarted(this.changeStartedEvent);
        }
    }

    public void fireGraphicsNodeChangeCompleted() {
        RootGraphicsNode rootGraphicsNode;
        if (this.changeCompletedEvent == null) {
            this.changeCompletedEvent = new GraphicsNodeChangeEvent(this, 9801);
        }
        if ((rootGraphicsNode = this.getRoot()) == null) {
            return;
        }
        List list = rootGraphicsNode.getTreeGraphicsNodeChangeListeners();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GraphicsNodeChangeListener graphicsNodeChangeListener = (GraphicsNodeChangeListener)iterator.next();
            graphicsNodeChangeListener.changeCompleted(this.changeCompletedEvent);
        }
    }

    public CompositeGraphicsNode getParent() {
        return this.parent;
    }

    public RootGraphicsNode getRoot() {
        return this.root;
    }

    protected void setRoot(RootGraphicsNode rootGraphicsNode) {
        this.root = rootGraphicsNode;
    }

    protected void setParent(CompositeGraphicsNode compositeGraphicsNode) {
        this.parent = compositeGraphicsNode;
    }

    protected void invalidateGeometryCache() {
        if (this.parent != null) {
            ((AbstractGraphicsNode)this.parent).invalidateGeometryCache();
        }
        this.bounds = null;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = this.filter == null ? this.getPrimitiveBounds() : this.filter.getBounds2D();
            if (this.bounds != null) {
                Rectangle2D rectangle2D;
                if (this.clip != null && (rectangle2D = this.clip.getClipPath().getBounds2D()).intersects(this.bounds)) {
                    Rectangle2D.intersect(this.bounds, rectangle2D, this.bounds);
                }
                if (this.mask != null && (rectangle2D = this.mask.getBounds2D()).intersects(this.bounds)) {
                    Rectangle2D.intersect(this.bounds, rectangle2D, this.bounds);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.bounds;
    }

    public Rectangle2D getTransformedBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        Rectangle2D rectangle2D = null;
        rectangle2D = this.filter == null ? this.getTransformedPrimitiveBounds(affineTransform) : affineTransform2.createTransformedShape(this.filter.getBounds2D()).getBounds2D();
        if (rectangle2D != null) {
            if (this.clip != null) {
                Rectangle2D.intersect(rectangle2D, affineTransform2.createTransformedShape(this.clip.getClipPath()).getBounds2D(), rectangle2D);
            }
            if (this.mask != null) {
                Rectangle2D.intersect(rectangle2D, affineTransform2.createTransformedShape(this.mask.getBounds2D()).getBounds2D(), rectangle2D);
            }
        }
        return rectangle2D;
    }

    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getPrimitiveBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    public Rectangle2D getTransformedGeometryBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getGeometryBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null || !rectangle2D.contains(point2D)) {
            return false;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.isVisible;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.getBounds().intersects(rectangle2D);
    }

    public GraphicsNode nodeHitAt(Point2D point2D) {
        return this.contains(point2D) ? this : null;
    }

    public abstract Shape getOutline();

    public abstract Rectangle2D getGeometryBounds();

    public abstract Rectangle2D getPrimitiveBounds();

    public abstract void primitivePaint(Graphics2D var1);
}

