/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.serialization;

import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.ejb.serialization.EJBSerializator;
import com.sap.engine.interfaces.ejb.serialization.StatefulInstanceInputStream;
import com.sap.engine.services.failover.serialization.FailoverInputStream;
import com.sap.engine.services.failover.serialization.FailoverOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Stack;

public class ObjectSerializator {
    private ComponentExecutionContext componentContext = null;
    private EJBSerializator ejbSerializator = null;

    public void serializeObjectGraph(OutputStream stream, Object obj) throws IOException {
        Stack statefulEJBeans = new Stack();
        FailoverOutputStream failoverStream = new FailoverOutputStream(new BufferedOutputStream(stream), statefulEJBeans);
        failoverStream.writeObject(obj);
        if (this.ejbSerializator != null) {
            this.ejbSerializator.writeStatefulSessions(statefulEJBeans, (ObjectOutputStream)failoverStream);
        } else {
            failoverStream.writeObject("END_OF_STREAM");
        }
        failoverStream.flush();
        failoverStream.close();
    }

    public Object deserializeObjectGraph(InputStream stream, ClassLoader appLoader) throws IOException, ClassNotFoundException {
        FailoverInputStream failoverInStream = new FailoverInputStream(stream, this.ejbSerializator, appLoader, this.componentContext);
        Object result = ((ObjectInputStream)((Object)failoverInStream)).readObject();
        if (this.ejbSerializator != null) {
            this.ejbSerializator.restoreStatefulSessions((StatefulInstanceInputStream)failoverInStream, failoverInStream.statefulSessionsMap);
        }
        ((ObjectInputStream)((Object)failoverInStream)).close();
        return result;
    }

    public void setEJBSerializator(EJBSerializator ser) {
        this.ejbSerializator = ser;
    }

    public void setComponentContext(ComponentExecutionContext ctx) {
        this.componentContext = ctx;
    }
}

