/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.serialization;

import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.ejb.serialization.EJBSerializator;
import com.sap.engine.interfaces.ejb.serialization.StatefulInstanceInputStream;
import com.sap.engine.services.failover.FailoverFrame;
import com.sap.engine.services.failover.exceptions.FailoverIOException;
import com.sap.engine.services.failover.serialization.EntityBeanReference;
import com.sap.engine.services.failover.serialization.ReplaceObject;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import com.sap.engine.services.rmi_p4.P4RemoteObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class FailoverInputStream
extends StatefulInstanceInputStream {
    private EJBSerializator ejbSerializator = null;
    private ClassLoader appClassLoader = null;
    private Object resSet = null;
    private ComponentExecutionContext componentContext = null;
    private Object sessionContext = null;
    private Hashtable statelessSessionsMap = null;
    protected Hashtable statefulSessionsMap = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    public FailoverInputStream(InputStream _inStream, EJBSerializator _ejbSerializator, ClassLoader _classLoader, ComponentExecutionContext _componentContext) throws IOException {
        super(_inStream);
        ((ObjectInputStream)((Object)this)).enableResolveObject(true);
        this.ejbSerializator = _ejbSerializator;
        this.appClassLoader = _classLoader;
        this.componentContext = _componentContext;
        this.statelessSessionsMap = new Hashtable();
        this.statefulSessionsMap = new Hashtable();
    }

    public Class resolveClass(ObjectStreamClass objClass) throws IOException, ClassNotFoundException {
        try {
            return this.appClassLoader.loadClass(objClass.getName());
        }
        catch (ClassNotFoundException ex) {
            return Class.forName(objClass.getName());
        }
    }

    public Object resolveObject(Object obj) throws IOException {
        if (obj instanceof ReplaceObject) {
            String str = ((ReplaceObject)obj).getConstant();
            if (str.startsWith("EJB")) {
                try {
                    Object ejbImpl = this.ejbSerializator.restoreReference(str.substring("EJB".length()), this.statefulSessionsMap, this.statelessSessionsMap);
                    Class<?> ejbClass = ejbImpl.getClass();
                    Class<?>[] interfaces = ejbClass.getInterfaces();
                    Class<?> ejbInterface = null;
                    int i = 0;
                    while (i < interfaces.length) {
                        if ((class$java$rmi$Remote == null ? FailoverInputStream.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(interfaces[i])) {
                            ejbInterface = interfaces[i];
                        }
                        ++i;
                    }
                    if (ejbInterface == null) {
                        FailoverFrame.traceInfo("Cannot find remote interface of {0}.", new String[]{ejbImpl.getClass().getName()});
                        return ejbImpl;
                    }
                    try {
                        P4ObjectBroker broker = P4ObjectBroker.init();
                        P4RemoteObject o = broker.loadObject((Remote)ejbImpl);
                        return broker.narrow((Object)broker.byteArrayToObject(broker.objectToByteArr(o)), ejbInterface);
                    }
                    catch (Exception exc) {
                        throw new FailoverIOException("failover_0001", exc);
                    }
                }
                catch (RemoteException ex) {
                    throw new FailoverIOException("failover_0002", ex);
                }
            }
            return this.replaceString(str);
        }
        if (obj instanceof EntityBeanReference) {
            Object ejbImpl = this.ejbSerializator.restoreEntityReference(((EntityBeanReference)obj).getId(), ((EntityBeanReference)obj).getPk());
            Class<?> ejbClass = ejbImpl.getClass();
            Class<?>[] interfaces = ejbClass.getInterfaces();
            Class<?> ejbInterface = null;
            int i = 0;
            while (i < interfaces.length) {
                if ((class$java$rmi$Remote == null ? FailoverInputStream.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(interfaces[i])) {
                    ejbInterface = interfaces[i];
                }
                ++i;
            }
            if (ejbInterface == null) {
                FailoverFrame.traceInfo("Cannot find remote interface of {0}.", new String[]{ejbImpl.getClass().getName()});
                return ejbImpl;
            }
            try {
                P4ObjectBroker broker = P4ObjectBroker.init();
                P4RemoteObject o = broker.loadObject((Remote)ejbImpl);
                return broker.narrow((Object)broker.byteArrayToObject(broker.objectToByteArr(o)), ejbInterface);
            }
            catch (Exception exc) {
                throw new FailoverIOException("failover_0001", exc);
            }
        }
        return obj;
    }

    public void setSessionContext(Object _sessionContext) {
        this.sessionContext = _sessionContext;
    }

    public void setComponentExecutionContext(Object _resSet) {
        this.resSet = _resSet;
    }

    private Object replaceString(String str) throws IOException {
        if (str.startsWith("JNDI_INT")) {
            return this.obtainJNDIInitialContext();
        }
        if (str.startsWith("JNDI_CTX")) {
            return this.obtainJNDIContext(str.substring("JNDI_CTX".length()));
        }
        if (str.startsWith("UT")) {
            return this.obtainUserTransaction();
        }
        if (str.startsWith("SC")) {
            return this.sessionContext;
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object obtainJNDIInitialContext() throws IOException {
        InitialContext initialContext;
        Object oldResSet = this.componentContext.setCurrentState(this.resSet);
        try {
            try {
                initialContext = new InitialContext();
                Object var4_4 = null;
            }
            catch (NamingException ne) {
                throw new FailoverIOException("failover_0003", ne);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.componentContext.setCurrentState(oldResSet);
            throw throwable;
        }
        this.componentContext.setCurrentState(oldResSet);
        return initialContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object obtainJNDIContext(String contextName) throws IOException {
        Object object;
        Object oldResSet = this.componentContext.setCurrentState(this.resSet);
        try {
            try {
                object = new InitialContext().lookup(contextName);
                Object var5_5 = null;
            }
            catch (NamingException ne) {
                throw new FailoverIOException("failover_0004", ne);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.componentContext.setCurrentState(oldResSet);
            throw throwable;
        }
        this.componentContext.setCurrentState(oldResSet);
        return object;
    }

    private Object obtainUserTransaction() throws IOException {
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)p).put("domain", "true");
        try {
            return new InitialContext(p).lookup("UserTransaction");
        }
        catch (NamingException ne) {
            throw new FailoverIOException("failover_0005", ne);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

