/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.db;

import com.sap.engine.services.failover.db.SQLStatements;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import javax.sql.DataSource;

public class DBCleaner
implements TimeoutListener {
    private static final Location LOCATION = Location.getLocation((String)"com.sap.engine.services.failover.db");
    private static final long INIT_TIME = 600000L;
    private static final long REPEAT_TIME = 86400000L;
    private TimeoutManager timeoutManager = null;
    private DataSource dataSource;

    public void setDataSource(DataSource _dataSource) {
        this.dataSource = _dataSource;
    }

    public void setTimeoutManager(TimeoutManager _timeoutManager) {
        this.timeoutManager = _timeoutManager;
    }

    public void start() {
        this.timeoutManager.registerTimeoutListener((TimeoutListener)this, 600000L, 86400000L, true);
    }

    public void timeout() {
        try {
            Connection conn = this.dataSource.getConnection();
            try {
                PreparedStatement ps = conn.prepareStatement(SQLStatements.getRemoveExpiredStatement());
                ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                ps.executeUpdate();
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            {
            }
        }
        catch (Exception exc) {
            LOCATION.traceThrowableT(400, null, (Throwable)exc);
        }
    }

    public boolean check() {
        return true;
    }

    public void unregister() {
        if (this.timeoutManager != null) {
            this.timeoutManager.unregisterTimeoutListener((TimeoutListener)this);
            this.timeoutManager = null;
        }
    }
}

