/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.failover.storage.PersistentStorage;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;

public class FailoverInfoCommand
implements Command {
    private String rootDir;
    private PersistentStorage storage;

    public void setRootDir(String _rootDir) {
        this.rootDir = _rootDir;
    }

    public void setStorage(PersistentStorage storage) {
        this.storage = storage;
    }

    public String getName() {
        return "failover_info";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (this.storage.getType() != "FilePersistentStorage") {
            out.println("\nThis command is only supported for file persistent storage.\n");
            return;
        }
        out.println();
        out.println();
        String columnNames = "  alias name  |             session ID              |  size (b) |   modified    ";
        out.println(columnNames);
        out.print("-------------------------------------------");
        out.println("------------------------------------");
        File root = new File(this.rootDir);
        File[] dirs = root.listFiles();
        int i = 0;
        while (i < dirs.length) {
            if (!dirs[i].isFile()) {
                char[] array = new char[columnNames.length()];
                Arrays.fill(array, ' ');
                StringBuffer result = new StringBuffer(new String(array));
                String aliasName = dirs[i].getName();
                int offset = (14 - aliasName.length()) / 2;
                result.insert(offset, aliasName);
                File[] files = dirs[i].listFiles();
                int j = 0;
                while (j < files.length) {
                    result.setCharAt(14, '|');
                    File serFile = files[j];
                    if (serFile.getName().endsWith(".ser")) {
                        String sessionId = serFile.getName();
                        if ((sessionId = sessionId.substring(0, sessionId.lastIndexOf(46))).startsWith("(J2EE")) {
                            sessionId = sessionId.substring(sessionId.indexOf(41) + 1);
                        }
                        offset = (36 - sessionId.length()) / 2;
                        result.insert(16 + offset, sessionId);
                        result.setCharAt(52, '|');
                        String size = new Long(serFile.length()).toString();
                        offset = (12 - size.length()) / 2;
                        result.insert(52 + offset, size);
                        result.setCharAt(64, '|');
                        String date = new Date(serFile.lastModified()).toString();
                        date = date.substring(date.indexOf(" ") + 1, 19).trim();
                        result.insert(66, date.substring(0, date.lastIndexOf(58)));
                        String toPrint = result.toString();
                        while (toPrint.endsWith(" ")) {
                            toPrint = toPrint.substring(0, toPrint.length() - 1);
                        }
                        out.println(toPrint);
                        result = new StringBuffer(new String(array));
                    }
                    ++j;
                }
            }
            ++i;
        }
        out.print("-------------------------------------------");
        out.println("------------------------------------");
        out.println();
        out.println();
    }

    public String getHelpMessage() {
        return "\n     Shell command for obtaining information about all the HTTP sessions,\n  which  have been serialized.  It shows the alias name,  the session ID,\n  the size in bytes of the  file on the disk and  the time when  the file\n  has been last modified.\n\n     The shown session  ID is not the whole  ID of the HTTP session.  The\n  real ID starts with the clusterID  of the dispatcher in brackets but it\n  is ommitted here for better visualization.\n\n     It can only be used in case of file system specified as a persistent\n.  storage.\n\n  Usage: failover_info\n\n";
    }

    public String getGroup() {
        return "failover";
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }
}

