/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.ejb.serialization.EJBSerializator;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.failover.FailoverManagementImpl;
import com.sap.engine.services.failover.command.FailoverInfoCommand;
import com.sap.engine.services.failover.db.DBCleaner;
import com.sap.engine.services.failover.exceptions.FailoverResourceAccessor;
import com.sap.engine.services.failover.serialization.ObjectSerializator;
import com.sap.engine.services.failover.storage.DatabasePersistentStorage;
import com.sap.engine.services.failover.storage.FilePersistentStorage;
import com.sap.engine.services.failover.storage.PersistentStorage;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.sql.DataSource;

public class FailoverFrame
implements ApplicationServiceFrame,
ContainerEventListener {
    public static final String FAILOVER_LOGGER_NAME = "failover";
    private static final String FAILOVER_CATEGORY_SERVER = "/System/Server";
    private static final String FAILOVER_LOCATION = "com.sap.engine.services.failover";
    private static final String FILE_PERSISTENT_STORAGE = "File";
    private static final String DATABASE_PERSISTENT_STORAGE = "Database";
    private ApplicationServiceContext serviceContext = null;
    private ObjectSerializator serializator = null;
    private PersistentStorage persistentStorage = null;
    private String rootDirectory = null;
    private ShellInterface shell = null;
    private Command[] commands = new Command[]{new FailoverInfoCommand()};
    private int commandsId = -1;
    private static Category category = null;
    private static Location location = null;
    private DBCleaner dbCleaner = null;
    private DataSource dataSource = null;

    public void start(ApplicationServiceContext appServiceContext) throws ServiceException {
        this.serviceContext = appServiceContext;
        this.serializator = new ObjectSerializator();
        this.initLog();
        int mask = 244;
        HashSet<String> names = new HashSet<String>(3);
        names.add("ejbserialization");
        names.add("appcontext");
        names.add("shell");
        names.add("timeout");
        names.add("dbpool");
        appServiceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        this.rootDirectory = this.serviceContext.getServiceState().getProperty("RootDirectoryName");
        ((FailoverInfoCommand)this.commands[0]).setRootDir(this.rootDirectory);
        String persistentStorageType = this.serviceContext.getServiceState().getProperty("PersistentStorage");
        try {
            this.persistentStorage = persistentStorageType.equals(FILE_PERSISTENT_STORAGE) ? new FilePersistentStorage(this.serializator, this.rootDirectory) : new DatabasePersistentStorage(this.serializator, this.dataSource);
        }
        catch (Exception e) {
            throw new ServiceException("failover_0211", null, e);
        }
        ((FailoverInfoCommand)this.commands[0]).setStorage(this.persistentStorage);
        this.serviceContext.getContainerContext().getObjectRegistry().registerInterface((Object)this.persistentStorage);
        FailoverManagementImpl managementInterface = new FailoverManagementImpl(this.persistentStorage);
        this.serviceContext.getServiceState().registerManagementInterface((ManagementInterface)managementInterface);
    }

    public void stop() {
        this.persistentStorage.destroy();
        if (this.dbCleaner != null) {
            this.dbCleaner.unregister();
        }
        this.serviceContext.getServiceState().unregisterContainerEventListener();
        if (this.commandsId != -1) {
            this.shell.unregisterCommands(this.commandsId);
            this.commandsId = -1;
        }
    }

    private void initLog() {
        category = Category.getCategory((String)FAILOVER_CATEGORY_SERVER);
        location = Location.getLocation((String)FAILOVER_LOCATION);
        FailoverResourceAccessor.init(category, location);
    }

    public static void logInfo(String message, String[] args) {
        location.log(300, category, (Object)message, (Object[])args);
    }

    public static void traceInfo(String message, String[] args) {
        location.infoT(category, message, (Object[])args);
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals("timeout")) {
            TimeoutManager timeoutManager = (TimeoutManager)serviceInterface;
            this.dbCleaner = new DBCleaner();
            this.dbCleaner.setTimeoutManager(timeoutManager);
            if (this.dataSource != null) {
                this.dbCleaner.setDataSource(this.dataSource);
                this.dbCleaner.start();
            }
        } else if (serviceName.equals("dbpool")) {
            InitialDirContext naming = null;
            try {
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ((Hashtable)p).put("domain", "true");
                naming = new InitialDirContext(p);
                this.dataSource = (DataSource)naming.lookup("jdbc/notx/SAP/BC_FO");
                if (this.persistentStorage != null && this.persistentStorage.getType().equals("DatabasePersistentStorage")) {
                    ((DatabasePersistentStorage)this.persistentStorage).setDataSource(this.dataSource);
                }
                if (this.dbCleaner != null) {
                    this.dbCleaner.setDataSource(this.dataSource);
                    this.dbCleaner.start();
                }
            }
            catch (NamingException ne) {
                location.traceThrowableT(500, null, (Throwable)ne);
            }
        }
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
        if (serviceName.equals("timeout") && this.dbCleaner != null) {
            this.dbCleaner.unregister();
            this.dbCleaner = null;
        }
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("ejbserialization")) {
            this.serializator.setEJBSerializator((EJBSerializator)interfaceImpl);
        } else if (interfaceName.equals("appcontext")) {
            this.serializator.setComponentContext((ComponentExecutionContext)interfaceImpl);
        } else if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            this.commandsId = this.shell.registerCommands(this.commands);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            if (this.commandsId != -1) {
                this.shell.unregisterCommands(this.commandsId);
                this.commandsId = -1;
            }
            this.shell = null;
        } else if (interfaceName.equals("ejbserialization")) {
            if (this.serializator != null) {
                this.serializator.setEJBSerializator(null);
            }
        } else if (interfaceName.equals("appcontext") && this.serializator != null) {
            this.serializator.setComponentContext(null);
        }
    }

    public void markForShutdown(long time) {
    }

    public boolean setServiceProperty(String key, String value) {
        return true;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return true;
    }
}

