/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences.pages;

import com.tssap.selena.model.preferences.pages.Messages;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StringGroupFieldEditor
extends FieldEditor {
    public static final String DEFAULT_SUFFIX_SEPARATOR = ",";
    private static final String ALL_SUFFIXES_KEY_SUFFIX = "$internal$all_suffixes$";
    private CheckboxTableViewer myCheckBoxViewer;
    private Button myAddButton;
    private Button myRemoveButton;
    private Composite myViewerPaneComposite;
    private String myCommonPrefix;
    private String mySeparator = ",";
    private Set mySuffixes;

    public StringGroupFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.myCommonPrefix = name;
        this.createControl(parent);
    }

    public String getPreferenceName() {
        throw new UnsupportedOperationException("This editor works with the set of properties with common prefix. Use getCommonPrefix() instead");
    }

    public void setCommonKeyPrefix(String prefix) {
        this.myCommonPrefix = prefix;
    }

    public String getCommonKeyPrefix() {
        return this.myCommonPrefix;
    }

    public void setSuffixSeparator(String separator) {
        this.mySeparator = separator;
    }

    public String getSuffixSeparator() {
        return this.mySeparator;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doLoadDefault() {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.myViewerPaneComposite = this.getViewerPaneComposite(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.myViewerPaneComposite.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.loadSuffixes();
        HashSet<String> checked = new HashSet<String>();
        Iterator suffixes = this.mySuffixes.iterator();
        while (suffixes.hasNext()) {
            String curSuffix = (String)suffixes.next();
            if (!this.getPreferenceStore().getBoolean(this.getFullKey(curSuffix))) continue;
            checked.add(curSuffix);
        }
        this.myCheckBoxViewer.setInput((Object)this.mySuffixes.toArray());
        this.myCheckBoxViewer.setCheckedElements(((AbstractCollection)checked).toArray());
    }

    protected void doStore() {
        Iterator suffixes = this.mySuffixes.iterator();
        while (suffixes.hasNext()) {
            String curSuffix = (String)suffixes.next();
            this.getPreferenceStore().setValue(this.getFullKey(curSuffix), this.myCheckBoxViewer.getChecked((Object)curSuffix));
        }
        this.saveAllSuffixes();
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.myViewerPaneComposite.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    private void loadSuffixes() {
        if (this.mySuffixes == null) {
            this.mySuffixes = new HashSet();
            IPreferenceStore store = this.getPreferenceStore();
            String allSuffixes = store.getString(this.getFullKey(ALL_SUFFIXES_KEY_SUFFIX));
            if (allSuffixes == null) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(allSuffixes, this.mySeparator);
            while (tokenizer.hasMoreTokens()) {
                String curSuffix = tokenizer.nextToken();
                this.mySuffixes.add(curSuffix);
            }
        }
    }

    private void saveAllSuffixes() {
        StringBuffer result = new StringBuffer();
        Iterator suffixes = this.mySuffixes.iterator();
        while (suffixes.hasNext()) {
            if (result.length() != 0) {
                result.append(this.getSuffixSeparator());
            }
            result.append((String)suffixes.next());
        }
        this.getPreferenceStore().setValue(this.getFullKey(ALL_SUFFIXES_KEY_SUFFIX), result.toString());
    }

    private String getFullKey(String suffix) {
        return this.myCommonPrefix + suffix;
    }

    private Composite getViewerPaneComposite(Composite parent) {
        if (this.myViewerPaneComposite == null) {
            this.myViewerPaneComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            this.myViewerPaneComposite.setLayout((Layout)layout);
            this.myCheckBoxViewer = CheckboxTableViewer.newCheckList((Composite)this.myViewerPaneComposite, (int)2048);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 4;
            gd.heightHint = 100;
            gd.horizontalIndent = 0;
            this.myCheckBoxViewer.getTable().setLayoutData((Object)gd);
            this.myCheckBoxViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.myCheckBoxViewer.setContentProvider((IContentProvider)this.createContentProvider());
            this.myCheckBoxViewer.setSorter(this.createSorter());
            this.myCheckBoxViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    StringGroupFieldEditor.this.myCheckBoxViewer = null;
                }
            });
            this.myCheckBoxViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.myCheckBoxViewer.getControl())});
            this.addButtons(this.myViewerPaneComposite);
        } else {
            this.checkParent((Control)this.myViewerPaneComposite, parent);
        }
        return this.myViewerPaneComposite;
    }

    private void addButtons(Composite parent) {
        if (this.myAddButton == null && this.myRemoveButton == null) {
            Composite buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            buttonBox.setLayout((Layout)layout);
            GridData buttonBoxData = new GridData();
            buttonBoxData.horizontalSpan = 1;
            buttonBoxData.verticalAlignment = 1;
            buttonBoxData.horizontalAlignment = 2;
            buttonBox.setLayoutData((Object)buttonBoxData);
            this.myAddButton = new Button(buttonBox, 0x1000000);
            this.myAddButton.setLayoutData((Object)StringGroupFieldEditor.getButtonLayout());
            this.myAddButton.setText(Messages.getString("StringGroupFieldEditor.Add"));
            SelectionAdapter addButtonListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.getSource() == StringGroupFieldEditor.this.myAddButton) {
                        InputDialog dialog = new InputDialog(StringGroupFieldEditor.this.myCheckBoxViewer.getControl().getShell(), StringGroupFieldEditor.this.getAddSuffixDialogTitle(), StringGroupFieldEditor.this.getAddSuffixDialogMessage(), "", StringGroupFieldEditor.this.getAddSuffixDialogValidator());
                        dialog.setBlockOnOpen(true);
                        if (dialog.open() == 0) {
                            String newSuffix = dialog.getValue();
                            if (!StringGroupFieldEditor.this.mySuffixes.contains(newSuffix)) {
                                StringGroupFieldEditor.this.myCheckBoxViewer.add((Object)newSuffix);
                                StringGroupFieldEditor.this.myCheckBoxViewer.setChecked((Object)newSuffix, true);
                                StringGroupFieldEditor.this.mySuffixes.add(newSuffix);
                            }
                        }
                    }
                }
            };
            this.myAddButton.addSelectionListener((SelectionListener)addButtonListener);
            this.myRemoveButton = new Button(buttonBox, 0x1000000);
            this.myRemoveButton.setLayoutData((Object)StringGroupFieldEditor.getButtonLayout());
            this.myRemoveButton.setText(Messages.getString("StringGroupFieldEditor.Remove"));
            SelectionAdapter removeButtonListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedSuffix;
                    ISelection selection;
                    if (e.getSource() == StringGroupFieldEditor.this.myRemoveButton && (selection = StringGroupFieldEditor.this.myCheckBoxViewer.getSelection()) instanceof IStructuredSelection && (selectedSuffix = (String)((IStructuredSelection)selection).getFirstElement()) != null) {
                        StringGroupFieldEditor.this.myCheckBoxViewer.remove((Object)selectedSuffix);
                        StringGroupFieldEditor.this.mySuffixes.remove(selectedSuffix);
                        StringGroupFieldEditor.this.getPreferenceStore().setToDefault(StringGroupFieldEditor.this.getFullKey(selectedSuffix));
                    }
                }
            };
            this.myRemoveButton.addSelectionListener((SelectionListener)removeButtonListener);
        }
    }

    private static GridData getButtonLayout() {
        GridData gd = new GridData(768);
        gd.horizontalIndent = 0;
        gd.widthHint = 61;
        return gd;
    }

    protected String getAddSuffixDialogMessage() {
        return Messages.getString("StringGroupFieldEditor.Select_new_metaclass");
    }

    protected String getAddSuffixDialogTitle() {
        return this.getAddSuffixDialogMessage();
    }

    protected IInputValidator getAddSuffixDialogValidator() {
        return null;
    }

    protected ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        };
    }

    protected IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected ViewerSorter createSorter() {
        return new ViewerSorter(){};
    }
}

