/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.preferences.SavedValues;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;

class WorkspaceValues
implements SavedValues {
    private static IPreferenceStore ourPreferenceStore = PlatformUI.getWorkbench().getPreferenceStore();
    private static WorkspaceValues outInstance;

    WorkspaceValues() {
    }

    static SavedValues getWorkspaceValues() {
        if (outInstance == null) {
            outInstance = new WorkspaceValues();
        }
        return outInstance;
    }

    public boolean contains(String name) {
        return ourPreferenceStore.contains(name);
    }

    public boolean getBoolean(String name) {
        String value = ourPreferenceStore.getString(name);
        if (value != null) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
        }
        return false;
    }

    public double getDouble(String name) {
        return ourPreferenceStore.getDouble(name);
    }

    public float getFloat(String name) {
        return ourPreferenceStore.getFloat(name);
    }

    public int getInt(String name) {
        return ourPreferenceStore.getInt(name);
    }

    public long getLong(String name) {
        return ourPreferenceStore.getLong(name);
    }

    public String getString(String name) {
        return ourPreferenceStore.getString(name);
    }

    public void setValue(String name, boolean value) {
        ourPreferenceStore.setValue(name, new Boolean(value).toString());
    }

    public void setValue(String name, double value) {
        ourPreferenceStore.setValue(name, value);
    }

    public void setValue(String name, float value) {
        ourPreferenceStore.setValue(name, value);
    }

    public void setValue(String name, int value) {
        ourPreferenceStore.setValue(name, value);
    }

    public void setValue(String name, long value) {
        ourPreferenceStore.setValue(name, value);
    }

    public void setValue(String name, String value) {
        ourPreferenceStore.setValue(name, value);
    }
}

