/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.preferences.PreferencesPlugin;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

class WorkspacePreferencesReader {
    static final String TAG_PREFERENCE = "preference";
    static final String ATTR_NAME = "name";
    static final String ATTR_TYPE = "type";
    static final String ATTR_VALUE = "value";
    private static WorkspacePreferencesReader myInstance;
    private HashMap myDefaultPreferences;

    WorkspacePreferencesReader() {
    }

    static WorkspacePreferencesReader getInstance() {
        if (myInstance == null) {
            myInstance = new WorkspacePreferencesReader();
        }
        return myInstance;
    }

    public Object getPreference(String name) {
        if (this.myDefaultPreferences == null) {
            this.myDefaultPreferences = new HashMap();
            this.readRegistry();
        }
        return this.myDefaultPreferences.get(name);
    }

    private void readRegistry() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        String pluginID = PreferencesPlugin.getPluginID();
        String extensionPoint = PreferencesPlugin.getDefaultPreferencesExtensionPoint();
        IExtensionPoint point = registry.getExtensionPoint(pluginID, extensionPoint);
        IExtension[] extensions = point.getExtensions();
        IConfigurationElement[] elements = null;
        int i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                this.readElement(elements[j]);
                ++j;
            }
            ++i;
        }
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_PREFERENCE.equals(element.getName())) {
            this.readPreference(element);
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            this.readElement(children[i]);
            ++i;
        }
    }

    private void readPreference(IConfigurationElement element) {
        String name = element.getAttribute(ATTR_NAME);
        String type = element.getAttribute(ATTR_TYPE);
        String value = element.getAttribute(ATTR_VALUE);
        if (name != null && type != null && value != null) {
            Object oValue;
            if ("Boolean".equals(type = type.trim())) {
                oValue = new Boolean(value);
            } else if ("Double".equals(type)) {
                oValue = new Double(value);
            } else if ("Float".equals(type)) {
                oValue = new Float(value);
            } else if ("Integer".equals(type)) {
                oValue = new Integer(value);
            } else if ("Long".equals(type)) {
                oValue = new Long(value);
            } else if ("String".equals(type)) {
                oValue = new String(value);
            } else {
                return;
            }
            this.myDefaultPreferences.put(name, oValue);
        }
    }
}

