/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.preferences.PreferenceStoreImpl;
import com.tssap.selena.model.preferences.SavedValues;
import com.tssap.selena.model.preferences.WorkspacePreferencesReader;
import com.tssap.selena.model.preferences.WorkspaceValues;
import org.eclipse.jface.preference.IPreferenceStore;

class WorkspacePreferenceStoreImpl
extends PreferenceStoreImpl
implements IPreferenceStore {
    private static WorkspacePreferencesReader ourWorkspaceDefaultValues;
    private static SavedValues ourWorkspaceValues;
    private static WorkspacePreferenceStoreImpl outWorkspaceInstance;

    private WorkspacePreferenceStoreImpl() {
        ourWorkspaceDefaultValues = WorkspacePreferencesReader.getInstance();
        ourWorkspaceValues = WorkspaceValues.getWorkspaceValues();
    }

    static IPreferenceStore getWorkspacePreferenceStore() {
        if (outWorkspaceInstance == null) {
            outWorkspaceInstance = new WorkspacePreferenceStoreImpl();
        }
        return outWorkspaceInstance;
    }

    public boolean getDefaultBoolean(String name) {
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        if (super.getDefaultBoolean(name)) {
            return super.getDefaultBoolean(name);
        }
        return false;
    }

    public double getDefaultDouble(String name) {
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        if (value != null && value instanceof Double) {
            return (Double)value;
        }
        if (0.0 != super.getDefaultDouble(name)) {
            return super.getDefaultDouble(name);
        }
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        if (value != null && value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (0.0f != super.getDefaultFloat(name)) {
            return super.getDefaultFloat(name);
        }
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        if (0 != super.getDefaultInt(name)) {
            return super.getDefaultInt(name);
        }
        return 0;
    }

    public long getDefaultLong(String name) {
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        if (0L != super.getDefaultLong(name)) {
            return super.getDefaultLong(name);
        }
        return 0L;
    }

    public String getDefaultString(String name) {
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        if (!"".equals(super.getDefaultString(name))) {
            return super.getDefaultString(name);
        }
        return "";
    }

    public boolean contains(String name) {
        if (ourWorkspaceValues.contains(name)) {
            return true;
        }
        Object value = ourWorkspaceDefaultValues.getPreference(name);
        return value != null;
    }

    protected SavedValues getSavedValues() {
        return ourWorkspaceValues;
    }

    protected IPreferenceStore getParentPreferenceStore() {
        return null;
    }
}

