/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.preferences.SavedValues;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

class ResourceValues
implements SavedValues {
    private IResource myResource;

    static SavedValues getResourceValues(IResource resource) {
        return new ResourceValues(resource);
    }

    ResourceValues(IResource resource) {
        this.myResource = resource;
    }

    public boolean contains(String name) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            String value = this.myResource.getPersistentProperty(qualifiedName);
            return value != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean getBoolean(String name) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            String value = this.myResource.getPersistentProperty(qualifiedName);
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public double getDouble(String name) {
        QualifiedName qualifiedName = this.getQualifiedName(name);
        try {
            String value = this.myResource.getPersistentProperty(qualifiedName);
            double d = Double.parseDouble(value);
            return d;
        }
        catch (NumberFormatException e) {
        }
        catch (CoreException e) {
            // empty catch block
        }
        return 0.0;
    }

    public float getFloat(String name) {
        QualifiedName qualifiedName = this.getQualifiedName(name);
        try {
            String value = this.myResource.getPersistentProperty(qualifiedName);
            float f = Float.parseFloat(value);
            return f;
        }
        catch (NumberFormatException e) {
        }
        catch (CoreException e) {
            // empty catch block
        }
        return 0.0f;
    }

    public int getInt(String name) {
        QualifiedName qualifiedName = this.getQualifiedName(name);
        try {
            String value = this.myResource.getPersistentProperty(qualifiedName);
            int i = Integer.parseInt(value);
            return i;
        }
        catch (NumberFormatException e) {
        }
        catch (CoreException e) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String name) {
        QualifiedName qualifiedName = this.getQualifiedName(name);
        try {
            String value = this.myResource.getPersistentProperty(qualifiedName);
            long l = Long.parseLong(value);
            return l;
        }
        catch (NumberFormatException e) {
        }
        catch (CoreException e) {
            // empty catch block
        }
        return 0L;
    }

    public String getString(String name) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            return this.myResource.getPersistentProperty(qualifiedName);
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public void setValue(String name, boolean value) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            this.myResource.setPersistentProperty(qualifiedName, value ? "true" : "false");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setValue(String name, double value) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            this.myResource.setPersistentProperty(qualifiedName, "" + value);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    public void setValue(String name, float value) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            this.myResource.setPersistentProperty(qualifiedName, "" + value);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setValue(String name, int value) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            this.myResource.setPersistentProperty(qualifiedName, "" + value);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setValue(String name, long value) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            this.myResource.setPersistentProperty(qualifiedName, "" + value);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    public void setValue(String name, String value) {
        try {
            QualifiedName qualifiedName = this.getQualifiedName(name);
            this.myResource.setPersistentProperty(qualifiedName, value);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private QualifiedName getQualifiedName(String name) {
        return new QualifiedName(null, name);
    }
}

