/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.preferences.SavedValues;

class ReferenceValues
implements SavedValues {
    private Reference myReference;

    static SavedValues getReferenceValues(Reference reference) {
        return new ReferenceValues(reference);
    }

    ReferenceValues(Reference reference) {
        this.myReference = reference;
    }

    public boolean contains(String name) {
        return this.myReference.hasProperty(name);
    }

    public boolean getBoolean(String name) {
        String value = this.myReference.getPropertyValue(name);
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return false;
    }

    public double getDouble(String name) {
        try {
            String value = this.myReference.getPropertyValue(name);
            double d = Double.parseDouble(value);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public float getFloat(String name) {
        try {
            String value = this.myReference.getPropertyValue(name);
            float f = Float.parseFloat(value);
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public int getInt(String name) {
        try {
            String value = this.myReference.getPropertyValue(name);
            int i = Integer.parseInt(value);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public long getLong(String name) {
        try {
            String value = this.myReference.getPropertyValue(name);
            long l = Long.parseLong(value);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public String getString(String name) {
        String value = this.myReference.getPropertyValue(name);
        if (value != null) {
            return value;
        }
        return "";
    }

    public void setValue(String name, boolean value) {
        this.myReference.setPropertyValue(name, "" + value);
    }

    public void setValue(String name, double value) {
        this.myReference.setPropertyValue(name, "" + value);
    }

    public void setValue(String name, float value) {
        this.myReference.setPropertyValue(name, "" + value);
    }

    public void setValue(String name, int value) {
        this.myReference.setPropertyValue(name, "" + value);
    }

    public void setValue(String name, long value) {
        this.myReference.setPropertyValue(name, "" + value);
    }

    public void setValue(String name, String value) {
        this.myReference.setPropertyValue(name, value);
    }
}

