/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.preferences.IExPreferenceStore;
import com.tssap.selena.model.preferences.PreferenceStoreImpl;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.preferences.ReferenceValues;
import com.tssap.selena.model.preferences.SavedValues;
import org.eclipse.jface.preference.IPreferenceStore;

class ReferencePreferenceStoreImpl
extends PreferenceStoreImpl
implements IExPreferenceStore {
    private Reference myReference;
    private SavedValues myReferenceValues;

    ReferencePreferenceStoreImpl(Reference reference) {
        this.myReference = reference;
        this.myReferenceValues = ReferenceValues.getReferenceValues(reference);
    }

    public boolean contains(String name) {
        if (this.myReferenceValues.contains(name)) {
            return true;
        }
        return this.getParentPreferenceStore().contains(name);
    }

    public boolean isValid() {
        return !this.myReference.isDeleted();
    }

    public IPreferenceStore getParentPreferenceStore() {
        Entity element = this.myReference.getParent();
        if (element instanceof Reference) {
            return PreferencesPlugin.getPreferenceStore("diagram", (Element)element);
        }
        if (element instanceof Model) {
            return PreferencesPlugin.getPreferenceStore("project", (Element)element);
        }
        if (element == null) {
            return PreferencesPlugin.getPreferenceStore("workspace", (Element)element);
        }
        return null;
    }

    protected SavedValues getSavedValues() {
        return this.myReferenceValues;
    }
}

