/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.elements.UniqueName;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;

class ReferencePreferenceStoreCache {
    private static ReferenceQueue queue = new ReferenceQueue();
    private static HashMap ourElement2PreferenceStore = new HashMap();

    ReferencePreferenceStoreCache() {
    }

    public static boolean contains(UniqueName uniqueName) {
        boolean result = false;
        WeakReference ref = (WeakReference)ourElement2PreferenceStore.get(uniqueName);
        result = ref != null && !ref.isEnqueued();
        return result;
    }

    public static IPreferenceStore get(UniqueName uniqueName) {
        IPreferenceStore preferenceStore = null;
        WeakReference ref = (WeakReference)ourElement2PreferenceStore.get(uniqueName);
        if (ref != null && !ref.isEnqueued()) {
            preferenceStore = (IPreferenceStore)ref.get();
        }
        ReferencePreferenceStoreCache.cleanup();
        return preferenceStore;
    }

    public static void put(UniqueName uniqueName, IPreferenceStore preferenceStore) {
        ourElement2PreferenceStore.put(uniqueName, new WeakReferenceEx(uniqueName, preferenceStore, queue));
    }

    public static void delete(UniqueName uniqueName) {
        ourElement2PreferenceStore.remove(uniqueName);
    }

    protected static void cleanup() {
        WeakReferenceEx ref = (WeakReferenceEx)queue.poll();
        while (ref != null) {
            ourElement2PreferenceStore.remove(ref.getUniqueName());
            ref = (WeakReferenceEx)queue.poll();
        }
    }

    private static class WeakReferenceEx
    extends WeakReference {
        private UniqueName myUniqueName;

        public WeakReferenceEx(UniqueName uniqueName, IPreferenceStore preferenceStore, ReferenceQueue queue) {
            super(preferenceStore, queue);
            this.myUniqueName = uniqueName;
        }

        public UniqueName getUniqueName() {
            return this.myUniqueName;
        }
    }
}

