/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.preferences.IExPreferenceStore;
import com.tssap.selena.model.preferences.PreferenceStoreImpl;
import com.tssap.selena.model.preferences.ResourceValues;
import com.tssap.selena.model.preferences.SavedValues;
import com.tssap.selena.model.preferences.WorkspacePreferenceStoreImpl;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;

class ProjectPreferenceStoreImpl
extends PreferenceStoreImpl
implements IExPreferenceStore {
    private IProject myProject;
    private SavedValues myResourceValues;
    private IPreferenceStore myWorkspacePreferenceStore;
    private static HashMap myProjectPreferenceStores = new HashMap();

    ProjectPreferenceStoreImpl(IProject project) {
        this.myProject = project;
        this.myResourceValues = ResourceValues.getResourceValues((IResource)project);
        this.myWorkspacePreferenceStore = WorkspacePreferenceStoreImpl.getWorkspacePreferenceStore();
    }

    static IPreferenceStore getProjectPreferenceStore(IProject project) {
        IPreferenceStore preferenceStore = (IPreferenceStore)myProjectPreferenceStores.get(project);
        if (preferenceStore == null) {
            preferenceStore = new ProjectPreferenceStoreImpl(project);
            myProjectPreferenceStores.put(project, preferenceStore);
        }
        return preferenceStore;
    }

    public boolean contains(String name) {
        if (this.myResourceValues.contains(name)) {
            return true;
        }
        return this.myWorkspacePreferenceStore.contains(name);
    }

    public boolean isValid() {
        return this.myProject.isOpen() && this.myProject.exists();
    }

    public IPreferenceStore getParentPreferenceStore() {
        return this.myWorkspacePreferenceStore;
    }

    protected SavedValues getSavedValues() {
        return this.myResourceValues;
    }
}

