/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.preferences.IExPreferenceStore;
import com.tssap.selena.model.preferences.ProjectPreferenceStoreImpl;
import com.tssap.selena.model.preferences.ReferencePreferenceStoreCache;
import com.tssap.selena.model.preferences.ReferencePreferenceStoreImpl;
import com.tssap.selena.model.preferences.WorkspacePreferenceStoreImpl;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferencesPlugin
extends AbstractUIPlugin {
    private static PreferencesPlugin ourPlugin;
    private static final String DEFAULT_PREFERENCES_EXTENSION_POINT = "defaultPreferences";

    public PreferencesPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourPlugin = this;
    }

    public static PreferencesPlugin getDefault() {
        return ourPlugin;
    }

    public static String getDefaultPreferencesExtensionPoint() {
        return DEFAULT_PREFERENCES_EXTENSION_POINT;
    }

    public static String getPluginID() {
        if (ourPlugin != null) {
            return ourPlugin.getDescriptor().getUniqueIdentifier();
        }
        return null;
    }

    public static IPreferenceStore getPreferenceStore(String level, Element element) {
        if ("workspace".equals(level)) {
            return WorkspacePreferenceStoreImpl.getWorkspacePreferenceStore();
        }
        if ("project".equals(level)) {
            UniqueName modelUniqueName = element.getModel().getUniqueName();
            IProject project = ModelUinSupport.getProject((UniqueName)modelUniqueName);
            if (project != null) {
                return ProjectPreferenceStoreImpl.getProjectPreferenceStore(project);
            }
        } else if ("diagram".equals(level) && element != null) {
            UniqueName uniqueName = element.getUniqueName();
            IExPreferenceStore preferenceStore = null;
            if (ReferencePreferenceStoreCache.contains(uniqueName) && !(preferenceStore = (IExPreferenceStore)ReferencePreferenceStoreCache.get(uniqueName)).isValid()) {
                ReferencePreferenceStoreCache.delete(uniqueName);
            }
            if (preferenceStore == null) {
                if (element instanceof Reference) {
                    preferenceStore = new ReferencePreferenceStoreImpl((Reference)element);
                }
                ReferencePreferenceStoreCache.put(uniqueName, preferenceStore);
            }
            return preferenceStore;
        }
        return null;
    }
}

