/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.preferences;

import com.tssap.selena.model.preferences.SavedValues;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

abstract class PreferenceStoreImpl
implements IPreferenceStore {
    private ArrayList myListenerList;
    private Map myDefaults = new HashMap();

    public PreferenceStoreImpl() {
        this.myListenerList = new ArrayList();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList arrayList = this.myListenerList;
        synchronized (arrayList) {
            this.myListenerList.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList arrayList = this.myListenerList;
        synchronized (arrayList) {
            ((AbstractCollection)this.myListenerList).remove(listener);
        }
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        int i = 0;
        while (i < this.myListenerList.size()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)this.myListenerList.get(i);
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            listener.propertyChange(event);
            ++i;
        }
    }

    public boolean getBoolean(String name) {
        if (this.getSavedValues().contains(name)) {
            return this.getSavedValues().getBoolean(name);
        }
        return this.getDefaultBoolean(name);
    }

    public double getDouble(String name) {
        if (this.getSavedValues().contains(name)) {
            return this.getSavedValues().getDouble(name);
        }
        return this.getDefaultDouble(name);
    }

    public float getFloat(String name) {
        if (this.getSavedValues().contains(name)) {
            return this.getSavedValues().getFloat(name);
        }
        return this.getDefaultFloat(name);
    }

    public int getInt(String name) {
        if (this.getSavedValues().contains(name)) {
            return this.getSavedValues().getInt(name);
        }
        return this.getDefaultInt(name);
    }

    public long getLong(String name) {
        if (this.getSavedValues().contains(name)) {
            return this.getSavedValues().getLong(name);
        }
        return this.getDefaultLong(name);
    }

    public String getString(String name) {
        if (this.getSavedValues().contains(name)) {
            return this.getSavedValues().getString(name);
        }
        return this.getDefaultString(name);
    }

    public void setValue(String name, boolean value) {
        this.getSavedValues().setValue(name, value);
        this.firePropertyChangeEvent(name, new Boolean(this.getBoolean(name)), new Boolean(value));
    }

    public void setValue(String name, double value) {
        this.getSavedValues().setValue(name, value);
        this.firePropertyChangeEvent(name, new Double(this.getDouble(name)), new Double(value));
    }

    public void setValue(String name, float value) {
        this.getSavedValues().setValue(name, value);
        this.firePropertyChangeEvent(name, new Float(this.getFloat(name)), new Float(value));
    }

    public void setValue(String name, int value) {
        this.getSavedValues().setValue(name, value);
        this.firePropertyChangeEvent(name, new Integer(this.getInt(name)), new Integer(value));
    }

    public void setValue(String name, long value) {
        this.getSavedValues().setValue(name, value);
        this.firePropertyChangeEvent(name, new Long(this.getLong(name)), new Long(value));
    }

    public void setValue(String name, String value) {
        this.getSavedValues().setValue(name, value);
        this.firePropertyChangeEvent(name, this.getString(name), value);
    }

    public boolean isDefault(String name) {
        boolean defaultBoolean = this.getDefaultBoolean(name);
        if (this.getBoolean(name) != defaultBoolean) {
            return false;
        }
        double defaultDouble = this.getDefaultDouble(name);
        if (this.getDouble(name) != defaultDouble) {
            return false;
        }
        float defaultFloat = this.getDefaultFloat(name);
        if (this.getFloat(name) != defaultFloat) {
            return false;
        }
        int defaultInt = this.getDefaultInt(name);
        if (this.getInt(name) != defaultInt) {
            return false;
        }
        long defaultLong = this.getDefaultLong(name);
        if (this.getLong(name) != defaultLong) {
            return false;
        }
        String defaultString = this.getDefaultString(name);
        return this.getString(name) == defaultString;
    }

    public boolean getDefaultBoolean(String name) {
        if (this.myDefaults.containsKey(name) && this.myDefaults.get(name) instanceof Boolean) {
            return (Boolean)this.myDefaults.get(name);
        }
        if (this.getParentPreferenceStore() != null) {
            return this.getParentPreferenceStore().getDefaultBoolean(name);
        }
        return false;
    }

    public double getDefaultDouble(String name) {
        if (this.myDefaults.containsKey(name) && this.myDefaults.get(name) instanceof Double) {
            return (Double)this.myDefaults.get(name);
        }
        if (this.getParentPreferenceStore() != null) {
            return this.getParentPreferenceStore().getDefaultDouble(name);
        }
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        if (this.myDefaults.containsKey(name) && this.myDefaults.get(name) instanceof Float) {
            return ((Float)this.myDefaults.get(name)).floatValue();
        }
        if (this.getParentPreferenceStore() != null) {
            return this.getParentPreferenceStore().getDefaultFloat(name);
        }
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        if (this.myDefaults.containsKey(name) && this.myDefaults.get(name) instanceof Integer) {
            return (Integer)this.myDefaults.get(name);
        }
        if (this.getParentPreferenceStore() != null) {
            return this.getParentPreferenceStore().getDefaultInt(name);
        }
        return 0;
    }

    public long getDefaultLong(String name) {
        if (this.myDefaults.containsKey(name) && this.myDefaults.get(name) instanceof Long) {
            return (Long)this.myDefaults.get(name);
        }
        if (this.getParentPreferenceStore() != null) {
            return this.getParentPreferenceStore().getDefaultLong(name);
        }
        return 0L;
    }

    public String getDefaultString(String name) {
        if (this.myDefaults.containsKey(name) && this.myDefaults.get(name) instanceof String) {
            return (String)this.myDefaults.get(name);
        }
        if (this.getParentPreferenceStore() != null) {
            return this.getParentPreferenceStore().getDefaultString(name);
        }
        return "";
    }

    public void setToDefault(String name) {
        boolean defaultBoolean = this.getDefaultBoolean(name);
        if (this.getBoolean(name) != defaultBoolean) {
            this.setValue(name, defaultBoolean);
            return;
        }
        double defaultDouble = this.getDefaultDouble(name);
        if (this.getDouble(name) != defaultDouble) {
            this.setValue(name, defaultDouble);
        }
        float defaultFloat = this.getDefaultFloat(name);
        if (this.getFloat(name) != defaultFloat) {
            this.setValue(name, defaultFloat);
        }
        int defaultInt = this.getDefaultInt(name);
        if (this.getInt(name) != defaultInt) {
            this.setValue(name, defaultInt);
        }
        long defaultLong = this.getDefaultLong(name);
        if (this.getLong(name) != defaultLong) {
            this.setValue(name, defaultLong);
        }
        String defaultString = this.getDefaultString(name);
        if (this.getString(name) != defaultString) {
            this.setValue(name, defaultString);
        }
    }

    public void setDefault(String name, boolean value) {
        this.myDefaults.put(name, new Boolean(value));
    }

    public void setDefault(String name, double value) {
        this.myDefaults.put(name, new Double(value));
    }

    public void setDefault(String name, float value) {
        this.myDefaults.put(name, new Float(value));
    }

    public void setDefault(String name, int value) {
        this.myDefaults.put(name, new Integer(value));
    }

    public void setDefault(String name, long value) {
        this.myDefaults.put(name, new Long(value));
    }

    public void setDefault(String name, String defaultObject) {
        this.myDefaults.put(name, defaultObject);
    }

    public void putValue(String name, String value) {
        this.setValue(name, value);
    }

    public boolean needsSaving() {
        return false;
    }

    protected abstract IPreferenceStore getParentPreferenceStore();

    protected abstract SavedValues getSavedValues();

    public abstract boolean contains(String var1);
}

