/*
 * Decompiled with CFR 0.152.
 */
package com.sap.p4japi.core;

import com.sap.p4japi.core.P4Command;
import com.sap.p4japi.core.P4Env;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class P4Process {
    public static String ENCODING = "ISO-8859-1";
    private boolean error = false;
    private String errorMessage = "";
    private int errorGeneric = -1;
    private int errorSeverity = -1;
    private Hashtable outputStat = null;
    private P4Command p4cmd;

    private P4Process() {
    }

    private P4Process(P4Command p4cmd) {
        this.outputStat = null;
        this.p4cmd = p4cmd;
    }

    private native void executeNative(String var1, String var2, String var3, String var4, String var5, Object[] var6, String var7, boolean var8, String var9);

    private static native String getNativeVersion();

    protected static P4Process execute(P4Env p4env, P4Command p4cmd) {
        String logFileName = p4env.getLogFile();
        PrintWriter log = null;
        try {
            if (logFileName != null) {
                log = new PrintWriter(new FileOutputStream(logFileName, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (log != null) {
            log.println("***********************************************************************************************");
            log.println("JNI-JAVA: execute started");
            log.println("JNI-JAVA: port = " + p4env.getP4Port());
            log.println("JNI-JAVA: user = " + p4env.getP4User());
            log.println("JNI-JAVA: client = " + p4env.getP4Client());
            log.println("JNI-JAVA: ztag = " + p4env.getZTag());
            log.println("JNI-JAVA: cmd = " + p4cmd.getCmd());
            Iterator iter = p4cmd.getParams().iterator();
            String paramsAsString = "";
            while (iter.hasNext()) {
                paramsAsString = paramsAsString + iter.next() + " ";
            }
            log.println("JNI-JAVA: params = " + paramsAsString);
            log.flush();
            log.close();
            log = null;
        }
        P4Process p4proc = new P4Process(p4cmd);
        p4proc.executeNative(p4env.getP4Port(), p4env.getP4User(), p4env.getP4Password(), p4env.getP4Client(), p4cmd.getCmd(), p4cmd.getParams().toArray(), P4Process.getInputString(p4cmd.getProperties()), p4env.getZTag(), logFileName);
        if (p4proc.outputStat != null) {
            p4proc.p4cmd.getP4OutputListener().readTable(p4proc.outputStat);
        }
        try {
            if (logFileName != null) {
                log = new PrintWriter(new FileOutputStream(logFileName, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (log != null) {
            log.println("JNI-JAVA: execute finished");
            log.println("***********************************************************************************************");
            log.close();
        }
        return p4proc;
    }

    boolean isError() {
        return this.error;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    int getErrorGeneric() {
        return this.errorGeneric;
    }

    int getErrorSeverity() {
        return this.errorSeverity;
    }

    private static String getInputString(Properties props) {
        String result = "";
        Enumeration keys = ((Hashtable)props).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result = result + key + ":" + ((Hashtable)props).get(key) + "\n";
        }
        try {
            return new String(result.getBytes(ENCODING));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void callReadLine(String line) {
        byte[] bline = null;
        try {
            bline = line.getBytes(ENCODING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.p4cmd.getP4OutputListener().readLine(new String(bline));
    }

    public void callAddTable() {
        if (this.outputStat == null) {
            this.outputStat = new Hashtable();
        } else {
            this.p4cmd.getP4OutputListener().readTable(this.outputStat);
            this.outputStat = new Hashtable();
        }
    }

    private void callAddTableItem(String key, String value) {
        this.outputStat.put(key, value);
    }

    protected static String getVersion() {
        return P4Process.getNativeVersion();
    }
}

