/*
 * Decompiled with CFR 0.152.
 */
package com.sap.p4japi.core;

import com.sap.p4japi.core.P4Command;
import com.sap.p4japi.core.P4Error;
import com.sap.p4japi.core.P4Exception;
import com.sap.p4japi.core.P4Process;

public class P4Env {
    private static final String version = "0.1.9 (22.07.2003)";
    private static boolean initialized = false;
    private static UnsatisfiedLinkError shOjbEx;
    private String p4port = "";
    private String p4user = "";
    private String p4password = "";
    private String p4client = "";
    private boolean zTag = false;
    private String logFileName = null;

    public P4Env() throws UnsatisfiedLinkError {
        if (!initialized) {
            throw shOjbEx;
        }
    }

    public P4Env(String sharedLib) throws UnsatisfiedLinkError {
        P4Env.loadSharedLib(sharedLib);
        if (!initialized) {
            throw shOjbEx;
        }
    }

    public P4Env(String sharedLib, String p4port, String p4user, String p4password, String p4client) throws UnsatisfiedLinkError {
        P4Env.loadSharedLib(sharedLib);
        if (!initialized) {
            throw shOjbEx;
        }
        this.p4port = p4port;
        this.p4user = p4user;
        this.p4password = p4password;
        this.p4client = p4client;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public String getP4Port() {
        return this.p4port;
    }

    public void setP4Port(String p4port) {
        this.p4port = p4port;
    }

    public String getP4User() {
        return this.p4user;
    }

    public void setP4User(String p4user) {
        this.p4user = p4user;
    }

    public String getP4Password() {
        return this.p4password;
    }

    public void setP4Password(String p4password) {
        this.p4password = p4password;
    }

    public String getP4Client() {
        return this.p4client;
    }

    public void setP4Client(String p4client) {
        this.p4client = p4client;
    }

    public boolean getZTag() {
        return this.zTag;
    }

    public void setZTag(boolean ztag) {
        this.zTag = ztag;
    }

    public void executeCommand(P4Command p4cmd) throws P4Exception {
        P4Process p4proc;
        if (this.logFileName != null && this.logFileName.length() == 0) {
            this.logFileName = null;
        }
        if ((p4proc = P4Process.execute(this, p4cmd)).isError()) {
            throw new P4Exception(new P4Error(p4proc.getErrorMessage(), p4proc.getErrorGeneric(), p4proc.getErrorSeverity()));
        }
    }

    public void setLogFile(String logFileName) {
        this.logFileName = logFileName;
    }

    public String getLogFile() {
        return this.logFileName;
    }

    private static void loadSharedLib(String sharedLib) throws UnsatisfiedLinkError {
        try {
            System.load(sharedLib);
            initialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            initialized = false;
            shOjbEx = e;
            throw shOjbEx;
        }
    }

    public static String getVersion() {
        return "Java library: 0.1.9 (22.07.2003), " + P4Process.getVersion();
    }
}

