/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.sapq.impl;

import com.sap.aii.proxy.framework.core.ApplicationFaultException;
import com.sap.aii.proxy.framework.core.SystemFaultException;
import com.sap.ip.bi.sdk.dac.connector.impl.BIMDRPersistence;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.relational.BIRelationalMetaDataConstants;
import com.sap.ip.bi.sdk.dac.connector.relational.MetaStore;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.relational.RelationalPersistenceMetaData;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.CatalogObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.ColumnObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.GenericSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableObject;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Funcarea_Catalog_Input;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Funcarea_Catalog_Output;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Funcarea_Fieldlist_Input;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.Rsaq_Remote_Funcarea_Fieldlist_Output;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqrfcatType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqrflistType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqrglistType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.RsaqspnameType;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.proxy.SAPQ_PortType;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BISqlAbapType;
import com.sap.ip.bi.sdk.util.impl.BISqlSchemaNameMatcher;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class SapqMDRConnection
extends RelationalMDRConnection
implements RelationalPersistenceMetaData {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqMDRConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqMDRConnection = SapqMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.sapq.impl.SapqMDRConnection")) : class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqMDRConnection).getName());
    private ServerRTCounter serverRTCounter = ServerRTCounter.getInstance();
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor = null;
    private final boolean useGlobalqueryArea;
    private MetaStore metaStore = new MetaStore();
    private JCO.Client client = null;
    private SAPQ_PortType sapq = null;
    private static final String QUALIFIED_TABLE_NAME = "org.omg.cwm.resource.relational.Table";
    static final String DUMMY_CATALOG = "SAPQUERY";
    static final String DUMMY_SCHEMA = "SAPQUERY";
    static final String TABLE_NAME = "TABLE-NAME";
    private static final String PARAMETER = "P";
    private static final String SELECT_OPTION = "S";
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$SapqMDRConnection;

    public SapqMDRConnection(JCO.Client client, IBIConnectionInfo connectionInfo) throws BIResourceException {
        super(connectionInfo);
        this.client = client;
        this.sapq = new SAPQ_PortType();
        try {
            this.sapq.messageSpecifier.setJcoClient(client);
            this.serverRTCounter.incrementCounter();
        }
        catch (JCO.Exception ex) {
            throw new BIResourceException(connectionInfo.getLocale(), "sdk.dac.connector.sapq_1001", new Object[]{client}, (Throwable)ex);
        }
        this.useGlobalqueryArea = client != null && "X".equals(client.getProperty(SapqConnectionConstants.QUERYAREA.toString()));
    }

    public void assertMetaDataLoaded() throws BIResourceException {
        String method = "assertMetaDataLoaded()";
        loggingLoc.entering("assertMetaDataLoaded()");
        try {
            this.client.isAlive();
            this.serverRTCounter.incrementCounter();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assertCatalogsLoaded() throws BIResourceException {
        block4: {
            block3: {
                String method = "assertCatalogsLoaded()";
                loggingLoc.entering("assertCatalogsLoaded()");
                try {
                    if (!this.metaStore.getCatalog().isEmpty()) {
                        Object var3_2 = null;
                        break block3;
                    }
                    this.metaStore.addCatalog(new CatalogObject("SAPQUERY"));
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return;
        }
        Object var3_3 = null;
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assertSchemasLoaded() throws BIResourceException {
        block4: {
            block3: {
                String method = "assertSchemasLoaded()";
                loggingLoc.entering("assertSchemasLoaded()");
                try {
                    if (!this.metaStore.getSchema().isEmpty()) {
                        Object var3_2 = null;
                        break block3;
                    }
                    this.assertCatalogsLoaded();
                    this.metaStore.addSchema(new SchemaObject("SAPQUERY", "SAPQUERY"));
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return;
        }
        Object var3_3 = null;
        loggingLoc.exiting();
    }

    public void assertSchemasLoaded(CatalogObject catalog) throws BIResourceException {
        String method = "assertSchemasLoaded(CatalogObject)";
        loggingLoc.entering("assertSchemasLoaded(CatalogObject)");
        try {
            if (catalog == null | !"SAPQUERY".equals(catalog.getCatalogName())) {
                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector_2018", new Object[]{catalog});
            }
            this.assertSchemasLoaded();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assertTablesLoaded() throws BIResourceException {
        block7: {
            block6: {
                String method = "assertTablesLoaded()";
                loggingLoc.entering("assertTablesLoaded()");
                try {
                    this.assertSchemasLoaded();
                    if (!this.metaStore.getTable().isEmpty()) {
                        Object var7_2 = null;
                        break block6;
                    }
                    Rsaq_Remote_Funcarea_Catalog_Input input = new Rsaq_Remote_Funcarea_Catalog_Input();
                    input.setWorkspace(this.useGlobalqueryArea ? "X" : " ");
                    try {
                        Rsaq_Remote_Funcarea_Catalog_Output output = this.sapq.rsaq_Remote_Funcarea_Catalog(input);
                        this.serverRTCounter.incrementCounter();
                        this.processRsaqRemoteFuncareaCatalogOutput(output);
                        break block7;
                    }
                    catch (ApplicationFaultException ex) {
                        BIResourceException rex = new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.sapq_2000", (Throwable)ex);
                        loggingLoc.throwing("assertTablesLoaded()", (Throwable)rex);
                        throw rex;
                    }
                    catch (SystemFaultException ex) {
                        BIResourceException rex = new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.sapq_2000", (Throwable)ex);
                        loggingLoc.throwing("assertTablesLoaded()", (Throwable)rex);
                        throw rex;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_4 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return;
        }
        Object var7_3 = null;
        loggingLoc.exiting();
    }

    public void assertTablesLoaded(SchemaObject schema) throws BIResourceException {
        String method = "assertTablesLoaded(SchemaObject)";
        loggingLoc.entering("assertTablesLoaded(SchemaObject)");
        try {
            if (schema == null | !"SAPQUERY".equals(schema.getSchemaName())) {
                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector_2018", new Object[]{schema});
            }
            this.assertTablesLoaded();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertColumnsLoaded(TableObject table) throws BIResourceException {
        String method = "assertColumnsLoaded(TableObject)";
        loggingLoc.entering("assertColumnsLoaded(TableObject)");
        try {
            block8: {
                this.assertTablesLoaded();
                if (table == null) break block8;
                if (this.metaStore.getColumn(table).isEmpty()) break block9;
            }
            Object var8_3 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        {
            block9: {
                return;
            }
            Rsaq_Remote_Funcarea_Fieldlist_Input input = new Rsaq_Remote_Funcarea_Fieldlist_Input();
            input.setWorkspace(this.useGlobalqueryArea ? "X" : " ");
            input.setFuncarea(table.getTableName());
            try {
                Rsaq_Remote_Funcarea_Fieldlist_Output output = this.sapq.rsaq_Remote_Funcarea_Fieldlist(input);
                this.serverRTCounter.incrementCounter();
                this.processRsaqRemoteFuncareaFieldlistOutput(output, table);
            }
            catch (ApplicationFaultException ex) {
                BIResourceException rex = new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.sapq_2000", (Throwable)ex);
                loggingLoc.throwing("assertColumnsLoaded(TableObject)", (Throwable)rex);
                throw rex;
            }
            catch (SystemFaultException ex) {
                BIResourceException rex = new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.sapq_2000", (Throwable)ex);
                loggingLoc.throwing("assertColumnsLoaded(TableObject)", (Throwable)rex);
                throw rex;
            }
        }
        Object var8_4 = null;
        loggingLoc.exiting();
    }

    public void assertTableColumnAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        String method = "assertTableColumnAssocLoaded(GenericSchemaObject)";
        loggingLoc.entering("assertTableColumnAssocLoaded(GenericSchemaObject)");
        try {
            if (obj == null || !(obj instanceof TableObject)) {
                throw new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector_2018", new Object[]{obj});
            }
            this.assertColumnsLoaded((TableObject)obj);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertCatalogSchemaAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        String method = "assertCatalogSchemaAssocLoaded(GenericSchemaObject)";
        loggingLoc.entering("assertCatalogSchemaAssocLoaded(GenericSchemaObject)");
        try {
            this.assertSchemasLoaded();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    public void assertSchemaTableAssocLoaded(GenericSchemaObject obj) throws BIResourceException {
        String method = "assertSchemaTableAssocLoaded(GenericSchemaObject)";
        loggingLoc.entering("assertSchemaTableAssocLoaded(GenericSchemaObject)");
        try {
            this.assertTablesLoaded();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List assertFindTable(String catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        List<Object> list;
        block11: {
            block10: {
                List list2;
                block9: {
                    List list3;
                    block8: {
                        String method = "assertFindTable(String, String, String, TableType[])";
                        loggingLoc.entering("assertFindTable(String, String, String, TableType[])");
                        try {
                            this.assertTablesLoaded();
                            if (catalog != null && !this.patternMatches(catalog, "SAPQUERY")) {
                                list3 = Collections.EMPTY_LIST;
                                Object var13_9 = null;
                                break block8;
                            }
                            if (schemaPattern != null && !this.patternMatches(schemaPattern, "SAPQUERY")) {
                                list2 = Collections.EMPTY_LIST;
                                break block9;
                            }
                            BISqlSchemaNameMatcher m = new BISqlSchemaNameMatcher(tableNamePattern, false);
                            HashSet<TableType> typeSet = null;
                            if (type != null) {
                                typeSet = new HashSet<TableType>();
                                int i = 0;
                                while (i < type.length) {
                                    typeSet.add(type[i]);
                                    ++i;
                                }
                            }
                            ArrayList<TableObject> tables = new ArrayList<TableObject>();
                            boolean found = false;
                            Iterator i = this.metaStore.getTable().entrySet().iterator();
                            while (true) {
                                if (!i.hasNext()) {
                                    if (!found) break;
                                    list = tables;
                                    break block10;
                                }
                                TableObject t = (TableObject)i.next().getValue();
                                if (t == null || typeSet != null && (typeSet == null || !typeSet.contains(t.getType())) || !m.match(t.getTableName())) continue;
                                tables.add(t);
                                found = true;
                            }
                            list = Collections.EMPTY_LIST;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var13_13 = null;
                            loggingLoc.exiting();
                            throw throwable;
                        }
                    }
                    loggingLoc.exiting();
                    return list3;
                }
                Object var13_10 = null;
                loggingLoc.exiting();
                return list2;
            }
            Object var13_11 = null;
            loggingLoc.exiting();
            return list;
        }
        Object var13_12 = null;
        loggingLoc.exiting();
        return list;
    }

    public MetaStore getMetaStore() {
        MetaStore metaStore;
        String method = "getMetaStore()";
        loggingLoc.entering("getMetaStore()");
        try {
            metaStore = this.metaStore;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return metaStore;
    }

    private boolean patternMatches(String pattern, String match) {
        String method = "patternMatches(String, String)";
        try {
            boolean bl = new BISqlSchemaNameMatcher(pattern, false).match(match);
            Object var6_5 = null;
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private void processRsaqRemoteFuncareaFieldlistOutput(Rsaq_Remote_Funcarea_Fieldlist_Output output, TableObject table) throws BIResourceException {
        String method = "processRsaqRemoteFuncareaFieldlistOutput(Rsaq_Remote_Funcarea_Fieldlist_Output, TableObject)";
        try {
            if (output == null) {
                Object var11_4 = null;
                return;
            }
            Iterator fcat = output.getFieldlist().iterator();
            while (fcat.hasNext()) {
                RsaqrflistType ftype = (RsaqrflistType)((Object)fcat.next());
                ColumnObject column = new ColumnObject(table, ftype.getName());
                column.setDisplayOnly(true);
                column.setSelectOnly(false);
                try {
                    column.setCharOctetLength(Integer.parseInt(ftype.getOleng()));
                    column.setColumnSize(Integer.parseInt(ftype.getOleng()));
                    column.setDataType((short)BISqlAbapType.getSqlTypeFromAbap((String)ftype.getType()));
                    column.setDecimalDigits(Integer.parseInt(ftype.getDecimals()));
                    column.setNumPrecRadix(10);
                    column.setNullable(0);
                    column.setTypeName(BISqlAbapType.getSQLTypeNameFromAbap((String)ftype.getType()));
                }
                catch (NumberFormatException ex) {
                    BIResourceException rex = new BIResourceException(((BIMDRPersistence)this).connectionInfo.getLocale(), "sdk.dac.connector.sapq_2000", (Throwable)ex);
                    loggingLoc.throwing("processRsaqRemoteFuncareaFieldlistOutput(Rsaq_Remote_Funcarea_Fieldlist_Output, TableObject)", (Throwable)rex);
                    throw rex;
                }
                this.metaStore.addColumn(column);
                this.metaStore.putTaggedValue((GenericSchemaObject)column, BIRelationalMetaDataConstants.COLUMN_DISPLAY_TAG.toString(), BIRelationalMetaDataConstants.DISPLAY_ONLY.toString());
            }
            Iterator gcat = output.getGroup_List().iterator();
            while (gcat.hasNext()) {
                RsaqrglistType gtype = (RsaqrglistType)((Object)gcat.next());
            }
            Iterator scat = output.getSel_Fields().iterator();
            while (scat.hasNext()) {
                RsaqspnameType stype = (RsaqspnameType)((Object)scat.next());
                ColumnObject column = new ColumnObject(table, stype.getFname());
                if (this.metaStore.containsColumn(column)) {
                    ColumnObject stored = (ColumnObject)this.metaStore.getColumn().get(column.toString());
                    stored.setDisplayOnly(false);
                    this.metaStore.getTaggedValues((GenericSchemaObject)stored).remove(BIRelationalMetaDataConstants.COLUMN_DISPLAY_TAG.toString());
                    continue;
                }
                column = new ColumnObject(table, stype.getFname().length() > 0 ? stype.getFname() : stype.getSpname());
                column.setCharOctetLength(Integer.parseInt(stype.getLength()));
                column.setColumnSize(Integer.parseInt(stype.getLength()));
                column.setDataType((short)BISqlAbapType.getSqlTypeFromAbap((String)stype.getType()));
                column.setDecimalDigits(0);
                column.setDescription(stype.getFtext());
                column.setDisplayOnly(false);
                column.setSelectOnly(true);
                column.setNumPrecRadix(10);
                column.setTypeName(BISqlAbapType.getSQLTypeNameFromAbap((String)stype.getType()));
                this.metaStore.addColumn(column);
                this.metaStore.putTaggedValue((GenericSchemaObject)column, BIRelationalMetaDataConstants.COLUMN_DISPLAY_TAG.toString(), BIRelationalMetaDataConstants.SELECT_ONLY.toString());
                if (PARAMETER.equals(stype.getKind())) {
                    this.metaStore.putTaggedValue((GenericSchemaObject)column, BIRelationalMetaDataConstants.COLUMN_SELECTION_TAG.toString(), BIRelationalMetaDataConstants.SINGLE_VALUE_SELECTION.toString());
                    continue;
                }
                if (!SELECT_OPTION.equals(stype.getKind())) continue;
                this.metaStore.putTaggedValue((GenericSchemaObject)column, BIRelationalMetaDataConstants.COLUMN_SELECTION_TAG.toString(), BIRelationalMetaDataConstants.SELECT_OPTION_SELECTION.toString());
            }
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            throw throwable;
        }
        Object var11_5 = null;
    }

    private void processRsaqRemoteFuncareaCatalogOutput(Rsaq_Remote_Funcarea_Catalog_Output output) {
        String method = "processRsaqRemoteFuncareaCatalogOutput(Rsaq_Remote_Funcarea_Catalog_Output)";
        try {
            if (output == null) {
                Object var8_3 = null;
                return;
            }
            SchemaObject schema = new SchemaObject("SAPQUERY", "SAPQUERY");
            Iterator qcat = output.getFuncareacatalog().iterator();
            while (qcat.hasNext()) {
                RsaqrfcatType qtype = (RsaqrfcatType)((Object)qcat.next());
                TableObject table = new TableObject(schema, qtype.getClas(), TableType.TABLE);
                if (!this.metaStore.containsSchema(schema)) {
                    this.metaStore.addSchema(schema);
                }
                this.metaStore.addTable(table);
            }
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            throw throwable;
        }
        Object var8_4 = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

