/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.sapq.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.BIRelational;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.relational.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.sapq.SapqConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.SapqMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.SapqQueryExecution;
import com.sap.ip.bi.sdk.dac.connector.sapq.impl.SapqQueryInfo;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQueryExpression;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.IBISapqQueryCall;
import com.sap.ip.bi.sdk.dac.relational.query.sapq.impl.BIParseQueryExpression;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.resource.ResourceException;

public class Connection
extends CommonConnection {
    private static final boolean tracePrivateMethods = false;
    private static final Location loggingLoc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.relational.CommonConnection")) : class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection).getName());
    private ServerRTCounter serverRTCounter = ServerRTCounter.getInstance();
    private static final Category loggingCat = BILoggingSetup.CONNECTION.getCategory();
    private static String[][] keys = new String[][]{{"jco.client.user", BIConnectionConstants.USERNAME.toString()}, {"jco.client.passwd", BIConnectionConstants.PASSWORD.toString()}, {"jco.client.lang", BIConnectionConstants.LANGUAGE.toString()}, {"jco.client.client", SapqConnectionConstants.CLIENT.toString()}, {"jco.client.mshost", SapqConnectionConstants.MESSAGESERVER.toString()}, {"jco.client.ashost", SapqConnectionConstants.APPLICATIONSERVER.toString()}, {"jco.client.sysnr", SapqConnectionConstants.SYSTEMNUMBER.toString()}, {"jco.client.group", SapqConnectionConstants.SERVERGROUP.toString()}, {"jco.client.r3name", SapqConnectionConstants.R3NAME.toString()}, {"jco.client.trace", SapqConnectionConstants.RFCTRACE.toString()}, {"jco.client.snc_mode", SapqConnectionConstants.SNCMODE.toString()}, {"jco.client.snc_partner", SapqConnectionConstants.SNCPARTNER.toString()}, {"jco.client.snc_qop", SapqConnectionConstants.SNCLEVEL.toString()}};
    private static final HashMap keyMap = new HashMap();
    private JCO.Client client = null;
    private SapqQueryExecution exec = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$relational$CommonConnection;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection;

    private Connection() {
        this.properties = new Properties();
        this.client = JCO.createClient((Properties)this.properties);
    }

    private Connection(Properties props) {
        Properties remapped = new Properties();
        Properties pooled = new Properties();
        if (this.properties != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                pooled.setProperty(key, props.getProperty(key));
                remapped.setProperty(key, props.getProperty(key));
                if (!keyMap.containsKey(key)) continue;
                remapped.setProperty((String)keyMap.get(key), props.getProperty(key));
            }
        }
        this.properties = pooled;
        this.client = JCO.createClient((Properties)remapped);
        this.serverRTCounter.incrementCounter();
    }

    public static Connection connect(Properties props) throws ResourceException {
        Connection connection;
        String method = "connect(Properties)";
        loggingLoc.entering("connect(Properties)", new Object[]{props});
        try {
            Connection c = new Connection(props);
            c.connectDB();
            connection = c;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet execute(IBIQuery query) throws BIResourceException {
        ResultSet resultSet;
        String method = "execute(IBIQuery)";
        loggingLoc.entering("execute(IBIQuery)");
        boolean isInRequest = this.monitorQuery.getCurrentRequest() != null;
        try {
            if (!isInRequest) {
                this.monitorQuery.startRequest(IBIMonitor.Request.QUERY);
            }
            this.monitorQuery.startComponent(class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.sapq.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection, "execute(IBIQuery)");
            if (query == null || !(query.getExpression() instanceof BIQueryExpression)) throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk_1000");
            IBISapqQueryCall s = new BIParseQueryExpression(query, ((BIRelational)this).connectionInfo).parse();
            if (this.exec == null) {
                this.exec = new SapqQueryExecution(this.client, ((BIRelational)this).connectionInfo);
            }
            SapqQueryInfo q = this.exec.generateQuery(s);
            ResultSet res = null;
            try {
                res = this.exec.executeQuery(s, q);
            }
            catch (Exception ex) {
                BIResourceException rex = new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_1200", (Throwable)ex);
                loggingLoc.throwing("execute(IBIQuery)", (Throwable)rex);
                this.exec.deleteQuery(q);
                throw rex;
            }
            this.exec.deleteQuery(q);
            resultSet = res;
            Object var10_10 = null;
            this.monitorQuery.endComponent(class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.sapq.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection, "execute(IBIQuery)");
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.monitorQuery.endComponent(class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.sapq.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$sapq$impl$Connection, "execute(IBIQuery)");
            if (!isInRequest) {
                this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
            }
            loggingLoc.exiting();
            throw throwable;
        }
        if (!isInRequest) {
            this.monitorQuery.endRequest(IBIMonitor.Request.QUERY);
        }
        loggingLoc.exiting();
        return resultSet;
    }

    public ResultSet execute(Object nativeQuery) throws BIResourceException {
        throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk_1000");
    }

    public Object getNativeRepresentation(IBIQuery query) throws BIResourceException {
        throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk_1000");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean supports(IBIRelational.Supports feature) {
        Boolean bl;
        block4: {
            Boolean bl2;
            block3: {
                String method = "supports(IBIRelational.Supports)";
                loggingLoc.entering("supports(IBIRelational.Supports)");
                try {
                    if (IBIRelational.Supports.ONLY_SELECT_OPTIONS_STYLE_WHERE.equals(feature)) {
                        bl2 = Boolean.TRUE;
                        Object var5_5 = null;
                        break block3;
                    }
                    bl = Boolean.FALSE;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return bl2;
        }
        Object var5_6 = null;
        loggingLoc.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAlive() throws BIResourceException {
        boolean bl;
        block6: {
            boolean bl2;
            block5: {
                String method = "isAlive()";
                loggingLoc.entering("isAlive()");
                try {
                    try {
                        if (this.client == null) {
                            bl2 = false;
                            Object var4_5 = null;
                            break block5;
                        }
                        this.serverRTCounter.incrementCounter();
                        bl = this.client.isAlive();
                        break block6;
                    }
                    catch (JCO.Exception ex) {
                        throw new BIRuntimeException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector.rel_4002", (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    loggingLoc.exiting();
                    throw throwable;
                }
            }
            loggingLoc.exiting();
            return bl2;
        }
        Object var4_6 = null;
        loggingLoc.exiting();
        return bl;
    }

    protected synchronized void connectMDR() throws BIResourceException {
        String method = "connectMDR()";
        try {
            try {
                this.mdr = new SapqMDRConnection(this.client, ((BIRelational)this).connectionInfo);
                this.outerMost = this.mdr.connect();
                this.trans = this.mdr.getLocalTransaction();
                this.trans.begin();
            }
            catch (ResourceException ex) {
                BIResourceException rex = new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector.mmr_1000", (Throwable)ex);
                loggingLoc.throwing("connectMDR()", (Throwable)ex);
                throw rex;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    protected synchronized void connectDB() throws BIResourceException {
        String method = "connectDB()";
        try {
            this.client.connect();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    protected synchronized void closeDB() throws BIResourceException {
        String method = "close()";
        loggingLoc.entering("close()");
        try {
            ((BIRelational)this).connectionInfo = IBIConnectionInfo.DEFAULT;
            try {
                this.client.disconnect();
                this.serverRTCounter.incrementCounter();
            }
            catch (JCO.Exception ex) {
                loggingLoc.errorT("close()", ex.getLocalizedMessage());
                throw new BIResourceException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
            }
            try {
                if (this.mdr != null) {
                    if (this.trans != null) {
                        this.trans.rollback();
                        this.trans = null;
                    }
                    this.mdr.close();
                    this.mdr = null;
                }
            }
            catch (ResourceException ex) {
                throw new BIRuntimeException(((BIRelational)this).connectionInfo.getLocale(), "sdk.dac.connector_2003", (Throwable)ex);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            loggingLoc.exiting();
            throw throwable;
        }
        loggingLoc.exiting();
    }

    protected boolean isAliveDB() {
        return this.client != null;
    }

    protected String getAttributeEISProductName() {
        if (this.isAliveDB()) {
            return "R/3 " + this.client.getSystemID() + " " + this.client.getSystemNumber();
        }
        return "unknown";
    }

    protected String getAttributeEISProductVersion() {
        if (this.isAliveDB()) {
            this.serverRTCounter.incrementCounter();
            return this.client.getAttributes().getRelease();
        }
        return "unknown";
    }

    protected String getAttributeUserName() {
        if (this.isAliveDB()) {
            return this.properties.getProperty(SapqConnectionProperties.Parameter.USER.toString());
        }
        return "unknown";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 0;
        while (i < keys.length) {
            keyMap.put(keys[i][1], keys[i][0]);
            ++i;
        }
    }
}

