/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.basesrvc.util;

public final class SAPStringBuffer {
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private char[] buffer;
    private int length = 0;
    private int resizeFactor = 2;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public SAPStringBuffer() {
        this(50);
    }

    public SAPStringBuffer(int capacity) {
        if (capacity < 0) {
            capacity = Integer.MAX_VALUE;
        }
        this.buffer = new char[capacity];
    }

    public SAPStringBuffer(int capacity, int resizeFactor) {
        this(capacity);
        this.setResizeFactor(resizeFactor);
    }

    public void setLength(int newLength) {
        this.ensureCapacity(newLength);
        this.length = newLength;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.buffer.length) {
            int newCapacity = (this.buffer.length + 1) * this.resizeFactor;
            while (newCapacity < capacity) {
                newCapacity *= this.resizeFactor;
            }
            char[] tempBuffer = new char[newCapacity];
            if (this.length > 0) {
                System.arraycopy(this.buffer, 0, tempBuffer, 0, this.length);
            }
            this.buffer = tempBuffer;
        }
    }

    public SAPStringBuffer append(char[] chars) {
        int tmpLength = this.length + chars.length;
        this.ensureCapacity(tmpLength);
        System.arraycopy(chars, 0, this.buffer, this.length, chars.length);
        this.length = tmpLength;
        return this;
    }

    public SAPStringBuffer append(int value) {
        return this.append(Integer.toString(value));
    }

    public SAPStringBuffer append(char value) {
        this.ensureCapacity(this.length + 1);
        this.buffer[this.length++] = value;
        return this;
    }

    public SAPStringBuffer append(boolean value) {
        return this.append(String.valueOf(value));
    }

    public SAPStringBuffer append(Object value) {
        return this.append(String.valueOf(value));
    }

    public SAPStringBuffer append(long value) {
        return this.append(Long.toString(value));
    }

    public SAPStringBuffer append(float value) {
        return this.append(Float.toString(value));
    }

    public SAPStringBuffer append(double value) {
        return this.append(Double.toString(value));
    }

    public SAPStringBuffer append(String value) {
        if (value == null) {
            value = String.valueOf(value);
        }
        int strLength = value.length();
        int tmpLength = this.length + strLength;
        this.ensureCapacity(tmpLength);
        value.getChars(0, strLength, this.buffer, this.length);
        this.length = tmpLength;
        return this;
    }

    public SAPStringBuffer append(String value, int start, int end) {
        if (value == null) {
            value = String.valueOf(value);
        }
        int tmpLength = this.length + (end - start);
        this.ensureCapacity(tmpLength);
        value.getChars(start, end, this.buffer, this.length);
        this.length = tmpLength;
        return this;
    }

    public SAPStringBuffer append(StringBuffer value) {
        if (value != null) {
            int strLength = value.length();
            int tmpLength = this.length + strLength;
            this.ensureCapacity(tmpLength);
            value.getChars(0, strLength, this.buffer, this.length);
            this.length = tmpLength;
        }
        return this;
    }

    public SAPStringBuffer append(SAPStringBuffer value) {
        if (value != null) {
            int strLength = value.length;
            int tmpLength = this.length + strLength;
            this.ensureCapacity(tmpLength);
            value.getChars(0, strLength, this.buffer, this.length);
            this.length = tmpLength;
        }
        return this;
    }

    public int indexOf(String value, int start) {
        char[] tmpChars = value.toCharArray();
        int charsLength = tmpChars.length;
        if (start > this.length || charsLength == 0) {
            return -1;
        }
        if (charsLength == 1) {
            return this.indexOf(tmpChars[0], start);
        }
        char first = tmpChars[0];
        int max = this.length - charsLength;
        int i = start;
        block0: while (true) {
            if (i < max && first != this.buffer[i]) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = 1;
            int k = i + 1;
            while (j < charsLength) {
                if (this.buffer[k] != tmpChars[j]) {
                    ++i;
                    continue block0;
                }
                ++j;
                ++k;
            }
            break;
        }
        return i;
    }

    public int indexOf(char value, int start) {
        if (start >= this.length) {
            return -1;
        }
        int i = start;
        while (i < this.length) {
            if (value == this.buffer[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char value) {
        return this.indexOf(value, 0);
    }

    /*
     * Unable to fully structure code
     */
    public int lastIndexOf(String value) {
        tmpChars = value.toCharArray();
        if (tmpChars.length == 0 || this.length <= 0) {
            return -1;
        }
        first = tmpChars[0];
        i = this.length - tmpChars.length;
        block0: while (true) {
            if (this.buffer[i] != first && i > -1) {
                --i;
                continue;
            }
            if (i < 0) {
                return -1;
            }
            j = 1;
            k = i + 1;
            while (j < tmpChars.length) {
                if (this.buffer[k] == tmpChars[j]) ** break;
                continue block0;
                ++j;
                ++k;
            }
            break;
        }
        return i;
    }

    public int lastIndexOf(char value) {
        if (this.length <= 0) {
            return -1;
        }
        int i = this.length - 1;
        while (i > -1) {
            if (this.buffer[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int indexOf(String value) {
        return this.indexOf(value, 0);
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public boolean startsWith(String value) {
        char[] tmpChars = value.toCharArray();
        if (tmpChars.length == 0 || tmpChars.length > this.length) {
            return false;
        }
        int i = 0;
        while (i < tmpChars.length) {
            if (this.buffer[i] != tmpChars[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean endsWith(String value) {
        char[] tmpChars = value.toCharArray();
        if (tmpChars.length == 0 || tmpChars.length > this.length) {
            return false;
        }
        int i = this.length - tmpChars.length;
        while (i < tmpChars.length) {
            if (this.buffer[i] != tmpChars[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void trim() {
        int front = 0;
        while (this.length > 0 && this.buffer[this.length - 1] == ' ') {
            --this.length;
        }
        while (front < this.length && this.buffer[front] == ' ') {
            ++front;
        }
        if (front > 0 && front < this.length) {
            int i = front;
            while (i < this.length) {
                this.buffer[i - front] = this.buffer[i];
                ++i;
            }
            this.length -= front;
        }
    }

    public boolean equals(SAPStringBuffer sapStringBuffer) {
        if (sapStringBuffer.length != this.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (sapStringBuffer.buffer[i] != this.buffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        Class<?> objectClass = obj.getClass();
        if (objectClass == (class$java$lang$String == null ? (class$java$lang$String = SAPStringBuffer.class$("java.lang.String")) : class$java$lang$String)) {
            return ((String)obj).equals(this.toString());
        }
        if (objectClass == (class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = SAPStringBuffer.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer)) {
            return ((StringBuffer)obj).toString().equals(this.toString());
        }
        return this.equals((SAPStringBuffer)obj);
    }

    public char[] getChars(int srcStart, int srcEnd, char[] dest, int destStart) {
        int srcLength = srcEnd - srcStart;
        if (srcStart < 0) {
            throw new ArrayIndexOutOfBoundsException(srcStart);
        }
        if (srcEnd > this.length) {
            throw new ArrayIndexOutOfBoundsException(srcEnd);
        }
        if (srcStart > srcEnd) {
            throw new ArrayIndexOutOfBoundsException(srcStart + 62 + srcEnd);
        }
        System.arraycopy(this.buffer, srcStart, dest, destStart, srcLength);
        return dest;
    }

    public char[] getChars() {
        char[] chars = new char[this.length];
        System.arraycopy(this.buffer, 0, chars, 0, this.length);
        return chars;
    }

    public int length() {
        return this.length;
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException(start);
        }
        if (end > this.length) {
            throw new ArrayIndexOutOfBoundsException(end);
        }
        if (start > this.length) {
            throw new StringIndexOutOfBoundsException(start - this.length);
        }
        return new String(this.buffer, start, end - start);
    }

    public String substring(int start) {
        return this.substring(start, this.length);
    }

    public void replace(char toReplace, char replace) {
        int i = 0;
        while (i < this.length) {
            if (this.buffer[i] == toReplace) {
                this.buffer[i] = replace;
            }
            ++i;
        }
    }

    public int[] indexesOf(String value, int start) {
        char[] tmpChars = value.toCharArray();
        if (start > this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(start) + '>' + this.length);
        }
        if (tmpChars.length == 0) {
            return new int[0];
        }
        int[] indexes = new int[this.length - start];
        int counter = 0;
        char first = tmpChars[0];
        int max = this.length - tmpChars.length;
        int i = 0;
        block0: while (true) {
            if (i <= max && this.buffer[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                if (counter == 0) {
                    return new int[0];
                }
                int[] tmpIndexes = new int[counter];
                System.arraycopy(indexes, 0, tmpIndexes, 0, counter);
                indexes = tmpIndexes;
                return indexes;
            }
            int j = 1;
            int k = i + 1;
            while (j < tmpChars.length) {
                if (this.buffer[k] != tmpChars[j]) {
                    ++i;
                    continue block0;
                }
                ++j;
                ++k;
            }
            indexes[counter++] = i;
            i += tmpChars.length;
        }
    }

    public char getCharAt(int index) {
        if (index < this.length) {
            return this.buffer[index];
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(index) + '>' + this.length);
    }

    public int[] indexesOf(char value, int start) {
        if (start > this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(start) + '>' + this.length);
        }
        int[] indexes = new int[this.length - start];
        int counter = 0;
        int i = 0;
        while (i < this.length) {
            if (this.buffer[i] == value) {
                indexes[counter++] = i;
            }
            ++i;
        }
        if (counter != this.length) {
            if (counter == 0) {
                indexes = new int[]{};
            } else {
                int[] tmpIndexes = new int[counter];
                System.arraycopy(indexes, 0, tmpIndexes, 0, counter);
                indexes = tmpIndexes;
            }
        }
        return indexes;
    }

    public void setResizeFactor(int resizeFactor) {
        if (this.buffer.length * resizeFactor > this.buffer.length) {
            this.resizeFactor = resizeFactor;
        }
    }

    public String[] substrings(char seperator) {
        int[] indexes = this.indexesOf(seperator, 0);
        if (indexes.length == 0) {
            return new String[0];
        }
        String[] strings = new String[indexes.length + 1];
        int start = 1;
        if (indexes[0] == 0) {
            strings[0] = EMPTY_STRING;
        } else {
            strings[0] = new String(this.buffer, 0, indexes[0]);
            start += indexes[0];
        }
        int i = 1;
        while (i < indexes.length) {
            strings[i] = new String(this.buffer, start, indexes[i] - start);
            start = indexes[i] + 1;
            ++i;
        }
        strings[indexes.length] = start < this.length ? new String(this.buffer, start, this.length - start) : EMPTY_STRING;
        return strings;
    }

    public String[] substrings(String seperator) {
        if (seperator == null) {
            throw new NullPointerException();
        }
        int sepLength = seperator.length();
        if (sepLength == 0) {
            return new String[0];
        }
        int[] indexes = this.indexesOf(seperator, 0);
        if (indexes.length == 0) {
            return new String[0];
        }
        String[] strings = new String[indexes.length + 1];
        int start = sepLength;
        if (indexes[0] == 0) {
            strings[0] = EMPTY_STRING;
        } else {
            strings[0] = new String(this.buffer, 0, indexes[0]);
            start += indexes[0];
        }
        int i = 1;
        while (i < indexes.length) {
            strings[i] = new String(this.buffer, start, indexes[i] - start);
            start = indexes[i] + sepLength + 1;
            ++i;
        }
        strings[indexes.length] = start < this.length ? new String(this.buffer, start, this.length - start) : EMPTY_STRING;
        return strings;
    }

    public void deleteCharAt(int index) {
        if (index >= this.length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index != this.length - 1) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.length - index - 1);
        }
        --this.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

