/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.basesrvc.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Iterators {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static Iterator unmodifiableIterator(Iterator it) {
        return new UnmodifiableIterator(it);
    }

    public static abstract class FilteringIterator
    implements Iterator {
        private static final Object END = new Object();
        private static final Object UNDEFINED = new Object();
        private final Iterator it;
        private Object lookAhead = UNDEFINED;

        public boolean hasNext() {
            if (this.lookAhead == UNDEFINED) {
                this.lookAhead();
            }
            return this.lookAhead != END;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.lookAhead;
            this.lookAhead();
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not yet implemented for a filtering iterator");
        }

        public FilteringIterator(Iterator it) {
            this.it = it != null ? it : EMPTY_ITERATOR;
        }

        protected abstract boolean isReturned(Object var1);

        private void lookAhead() {
            while (this.it.hasNext()) {
                this.lookAhead = this.it.next();
                if (!this.isReturned(this.lookAhead)) continue;
                return;
            }
            this.lookAhead = END;
        }
    }

    public static class UnmodifiableIterator
    implements Iterator {
        private final Iterator it;

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return this.it.next();
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public UnmodifiableIterator(Iterator it) {
            this.it = it != null ? it : EMPTY_ITERATOR;
        }
    }
}

