/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ui.service;

import java.text.MessageFormat;

public class TextPool {
    protected static TextPool mTextPool;
    public static final int COPY = 1;
    public static final int BROWSE = 2;
    public static final int NAME = 3;
    public static final int PACKAGE = 4;
    public static final int SOURCE_FOLDER = 5;
    public static final int LABEL_CHANGES_TO_BE_PERFORMED = 100;
    public static final int LABEL_GREY_OBJECTS = 102;
    public static final int LABEL_CHOOSE_SCOPE = 103;
    public static final int LABEL_MINIMUM_SCOPE = 104;
    public static final int LABEL_MAXIMUM_SCOPE = 105;
    public static final int LABEL_TOOLDEFINED_SCOPE = 106;
    public static final int LABEL_BROWSE = 107;
    public static final int LABEL_NEW_NAME = 108;
    public static final int LABEL_NEW_PACKAGE = 109;
    public static final int LABEL_SOURCE_FOLDER = 110;
    public static final int LABEL_RENAME = 111;
    public static final int LABEL_RENAME_DOTS = 112;
    public static final int WIZARD_TITLE_REFACTOR = 200;
    public static final int WIZARD_NAME_PREVIEW = 201;
    public static final int WIZARD_DESCRIPTION_REFACTOR = 300;
    public static final int WIZARD_DESCRIPTION_REFACTOR_PREVIEW = 301;
    public static final int DIALOG_TITLE_SAVE_ALL = 400;
    public static final int DIALOG_DESCRIPTION_SAVE_ALL = 401;
    public static final int ERROR_NO_SOURCEFOLDER = 500;
    public static final int TEXT_REFACTORING = 600;
    public static final int TEXT_OBJECT = 601;

    public static final TextPool getInstance() {
        if (mTextPool == null) {
            mTextPool = new TextPool();
        }
        return mTextPool;
    }

    private static String insertArguments(String text, Object[] arguments) {
        if (text != null) {
            return MessageFormat.format(text, arguments);
        }
        return null;
    }

    public final String getText(int textId, Object[] arguments) {
        return TextPool.insertArguments(this.getText(textId), arguments);
    }

    public final String getText(int textId, Object argument1) {
        return this.getText(textId, new Object[]{argument1});
    }

    public final String getText(int textId, Object argument1, Object argument2) {
        return this.getText(textId, new Object[]{argument1, argument2});
    }

    public String getText(int textId) {
        switch (textId) {
            case 1: {
                return "Copy";
            }
            case 2: {
                return "Browse";
            }
            case 3: {
                return "Name";
            }
            case 4: {
                return "Package";
            }
            case 5: {
                return "Source Folder";
            }
            case 100: {
                return "Changes to be performed:";
            }
            case 102: {
                return "Note:\nGrayed-out objects are mandatory and cannot be excluded from refactoring";
            }
            case 103: {
                return "Choose the scope to be searched for references to update:";
            }
            case 104: {
                return "minimum scope";
            }
            case 105: {
                return "maximum scope (Note: this can be quite time-intensive)";
            }
            case 106: {
                return "tool-defined scope (recommended)";
            }
            case 107: {
                return "Browse...";
            }
            case 108: {
                return "New name";
            }
            case 109: {
                return "New package";
            }
            case 110: {
                return "Source folder";
            }
            case 111: {
                return "Rename";
            }
            case 112: {
                return "Rename...";
            }
            case 200: {
                return "Refactor";
            }
            case 201: {
                return "Preview";
            }
            case 301: {
                return "The following objects contain references to the refactored {0} and need to be changed.";
            }
            case 300: {
                return "Specify the necessary refactoring information for the selected element.";
            }
            case 400: {
                return "Confirm save of Metamodel";
            }
            case 401: {
                return "This action requires the saving of the whole metamodel. \nDo you wish to proceed?";
            }
            case 500: {
                return "Error: no source folder available";
            }
            case 600: {
                return "Refactoring";
            }
            case 601: {
                return "object";
            }
        }
        return null;
    }
}

