/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ui.dialog.wizard.refactor;

import com.sap.ide.webdynpro.ui.dialog.wizard.refactor.IRefactorWizardData;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.sap.ide.webdynpro.ui.service.TextPool;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public abstract class WDRefactorWizardPage
extends WizardPage {
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String PAGENAME;
    private static final String TITLE;
    private String DESCRIPTION = mTPool.getText(300);
    private final String NEW_NAME = mTPool.getText(108);
    private final String NEW_PACKAGE = mTPool.getText(109);
    private final String SOURCE_FOLDER = mTPool.getText(110);
    private final String BROWSE = mTPool.getText(107);
    private Text mNameField = null;
    private Text mPackageField = null;
    private Button mBrowsePackageButton = null;
    private List mSourcePathList = null;
    private Label mNameLabel = null;
    private Label mPackageLabel = null;
    private Label mSourceFolderLabel = null;
    private Label mWarningLabel = null;
    private Label mImageLabel = null;

    public WDRefactorWizardPage() {
        super(PAGENAME, TITLE, SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_REFACTOR_BANNER));
        this.setDescription(this.DESCRIPTION);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        IGridLayoutPane wizardPane = PaneFactory.createGridLayoutPane((Composite)root, (int)3);
        this.addNameSection(wizardPane);
        wizardPane.addPlaceholder();
        this.addPackageSection(wizardPane);
        wizardPane.addPlaceholder(100, 15);
        this.addWarningSection(wizardPane);
        this.initializeFields();
        this.initializeListeners();
        if (!this.getWizardData().showPackageSection()) {
            this.hidePackageSection();
        }
        if (this.getWizardData().showWarningSection()) {
            this.showWarningSection();
        }
    }

    private void addNameSection(IGridLayoutPane wizardPane) {
        this.mNameLabel = wizardPane.addTextLabel(this.NEW_NAME);
        GridData nameLabelGridData = new GridData(1808);
        nameLabelGridData.widthHint = 80;
        this.mNameLabel.setLayoutData((Object)nameLabelGridData);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mNameField = wizardPane.addTextField("", false, gridLayoutData);
        GridData nameGridData = new GridData(1808);
        nameGridData.widthHint = 270;
        this.mNameField.setLayoutData((Object)nameGridData);
    }

    private void addPackageSection(IGridLayoutPane wizardPane) {
        this.mPackageLabel = wizardPane.addTextLabel(this.NEW_PACKAGE);
        IGridLayoutData gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        this.mPackageField = wizardPane.addTextField("", false, gridLayoutData);
        GridData packageGridData = new GridData(1808);
        packageGridData.widthHint = 270;
        this.mPackageField.setLayoutData((Object)packageGridData);
        this.mBrowsePackageButton = wizardPane.addPushButton(this.BROWSE);
        this.mSourceFolderLabel = wizardPane.addTextLabel(this.SOURCE_FOLDER);
        gridLayoutData = wizardPane.createGridLayoutData(1, 1, true, false);
        IPackageFragmentRoot[] roots = this.getWizardData().getAllValidRoots();
        String[] items = null;
        int preselectionIndex = 0;
        if (roots != null) {
            items = new String[roots.length];
            IPackageFragmentRoot selectedRoot = this.getWizardData().getSelectedRoot();
            int i = 0;
            while (i < roots.length) {
                items[i] = roots[i].getPath().removeFirstSegments(1).makeRelative().toString();
                if (roots[i].equals(selectedRoot)) {
                    preselectionIndex = i;
                }
                ++i;
            }
        } else {
            items = new String[]{};
        }
        this.mSourcePathList = wizardPane.addList(items, false, gridLayoutData);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 40;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        this.mSourcePathList.setSelection(preselectionIndex);
    }

    private void addWarningSection(IGridLayoutPane wizardPane) {
        Image image = JFaceResources.getImageRegistry().get("dialog_warning_image");
        if (image != null) {
            this.mImageLabel = wizardPane.addTextLabel("");
            GridData imageLabelGridData = new GridData(1808);
            imageLabelGridData.widthHint = 80;
            this.mImageLabel.setLayoutData((Object)imageLabelGridData);
            this.mImageLabel.setImage(image);
        }
        this.mWarningLabel = wizardPane.addTextLabel(this.getWarningMessage());
        GridData nameLabelGridData = new GridData(1808);
        nameLabelGridData.widthHint = 80;
        this.mNameLabel.setLayoutData((Object)nameLabelGridData);
        this.mImageLabel.setVisible(false);
        this.mWarningLabel.setVisible(false);
    }

    protected void hidePackageSection() {
        this.mPackageLabel.setVisible(false);
        this.mPackageField.setVisible(false);
        this.mBrowsePackageButton.setVisible(false);
        this.mSourceFolderLabel.setVisible(false);
        this.mSourcePathList.setVisible(false);
    }

    protected void showWarningSection() {
        this.mImageLabel.setVisible(true);
        this.mWarningLabel.setVisible(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mNameField.setFocus();
        }
    }

    public Text getNameField() {
        return this.mNameField;
    }

    public Text getPackageField() {
        return this.mPackageField;
    }

    public Button getBrowsePackageButton() {
        return this.mBrowsePackageButton;
    }

    public List getSourcePathListField() {
        return this.mSourcePathList;
    }

    public abstract IRefactorWizardData getWizardData();

    protected abstract void initializeListeners();

    protected abstract void initializeFields();

    protected abstract String getWarningMessage();

    static {
        TITLE = PAGENAME = mTPool.getText(200);
    }
}

