/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ui.dialog.selection;

import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SelectWDApplicationDialog {
    Application[] mApplications = null;
    Application mSelectedApplication = null;

    public SelectWDApplicationDialog(Application[] applications) {
        this.mApplications = applications;
    }

    public void show(Shell pShell) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(pShell, (ILabelProvider)new Provider());
        if (this.mApplications == null || this.mApplications.length == 0) {
            dialog.setMessage("No applications");
        }
        dialog.setElements((Object[])this.mApplications);
        dialog.setTitle("Select Web Dynpro Application");
        dialog.setMessage("Choose a Web Dynpro Application");
        dialog.setMultipleSelection(false);
        if (0 == dialog.open()) {
            this.mSelectedApplication = (Application)dialog.getFirstResult();
        }
    }

    public Application getApplication() {
        return this.mSelectedApplication;
    }

    class Provider
    extends LabelProvider {
        Provider() {
        }

        public String getText(Object element) {
            if (element instanceof Application) {
                Application application = (Application)element;
                return application.getName() + " (" + application.getPackage() + ")";
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof Application) {
                return SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_APPLICATION);
            }
            return super.getImage(element);
        }
    }
}

