/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ui.dialog;

import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.webdynpro.ui.service.TextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchColors;

public class WDCopyDialog
extends Dialog {
    private static final TextPool mTPool = TextPool.getInstance();
    private final String COPY = mTPool.getText(1);
    private final String BROWSE = mTPool.getText(2);
    private final String NAME = mTPool.getText(3);
    private final String PACKAGE = mTPool.getText(4);
    private final String FOLDER = mTPool.getText(5);
    private Text mNameField = null;
    private Text mPackageField = null;
    private Button mBrowsePackageButton = null;
    private List mSourcePathList = null;
    private Label mMessageLabel = null;
    private String mMessage = null;
    private String mTitle = null;
    private IPackageFragmentRoot[] mAllValidRoots = null;
    private String mName = null;
    private String mPackage = null;
    private IPackageFragmentRoot mSelectedRoot = null;

    public WDCopyDialog(IPackageFragmentRoot[] allValidRoots, String title, String message) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(67696);
        if (allValidRoots != null && allValidRoots.length > 0) {
            this.mAllValidRoots = allValidRoots;
        } else {
            this.setErrorMessage(mTPool.getText(500));
        }
        this.mMessage = message;
        this.mTitle = title == null || title.equals("") ? this.COPY : title;
    }

    protected void buttonPressed(int id) {
        super.buttonPressed(id);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.mTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.initializeListeners();
        this.initializeFields();
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        ((GridLayout)parentComposite.getLayout()).numColumns = 1;
        IGridLayoutPane userArea = PaneFactory.createGridLayoutPane((Composite)parentComposite, (int)3);
        GridData userAreaData = new GridData(1808);
        userArea.setLayoutData((Object)userAreaData);
        IGridLayoutData gridLayoutData = userArea.createGridLayoutData(4, 4, true, false);
        userArea.addTextLabel(this.NAME);
        gridLayoutData = userArea.createGridLayoutData(1, 1, true, false);
        this.mNameField = userArea.addTextField("", false, gridLayoutData);
        GridData viewGridData = new GridData(1808);
        viewGridData.widthHint = 270;
        this.mNameField.setLayoutData((Object)viewGridData);
        userArea.addPlaceholder();
        userArea.addTextLabel(this.PACKAGE);
        gridLayoutData = userArea.createGridLayoutData(1, 1, true, false);
        this.mPackageField = userArea.addTextField("", false, gridLayoutData);
        GridData packageGridData = new GridData(1808);
        packageGridData.widthHint = 270;
        this.mPackageField.setLayoutData((Object)packageGridData);
        this.mBrowsePackageButton = userArea.addPushButton(this.BROWSE);
        String[] items = new String[this.mAllValidRoots.length];
        int i = 0;
        while (i < this.mAllValidRoots.length) {
            items[i] = this.mAllValidRoots[i].getPath().removeFirstSegments(1).makeRelative().toString();
            ++i;
        }
        Label sourceLabel = userArea.addTextLabel(this.FOLDER);
        gridLayoutData = userArea.createGridLayoutData(1, 1, true, false);
        this.mSourcePathList = userArea.addList(items, false, gridLayoutData);
        GridData pathGridData = new GridData(1808);
        pathGridData.widthHint = 270;
        pathGridData.heightHint = 30;
        this.mSourcePathList.setLayoutData((Object)pathGridData);
        userArea.addPlaceholder();
        IGridLayoutPane downArea = PaneFactory.createGridLayoutPane((Composite)parentComposite, (int)1);
        this.mMessageLabel = downArea.addTextLabel("");
        GridData messageGridData = new GridData(1808);
        messageGridData.widthHint = 400;
        this.mMessageLabel.setLayoutData((Object)messageGridData);
        return parentComposite;
    }

    protected void initializeListeners() {
        this.getNameField().addModifyListener((ModifyListener)new NameModifyListener());
        this.getPackageField().addModifyListener((ModifyListener)new PackageModifyListener());
        this.getBrowsePackageButton().addMouseListener((MouseListener)new BrowsePackageButtonListener());
        this.getSourcePathListField().addSelectionListener((SelectionListener)new SourceSelectionListener());
    }

    protected void initializeFields() {
        this.getNameField().setText("");
        this.getPackageField().setText("");
        if (this.mAllValidRoots != null && this.mAllValidRoots.length > 0) {
            this.getSourcePathListField().setSelection(0);
            this.mSelectedRoot = this.mAllValidRoots[0];
        }
    }

    public void setErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.mMessageLabel.setForeground(WorkbenchColors.getColor((RGB)new RGB(255, 0, 0)));
        this.mMessageLabel.setText(message);
    }

    public void setMessage(String message, int status) {
        if (message == null) {
            message = "";
        }
        this.mMessageLabel.setForeground(WorkbenchColors.getColor((RGB)new RGB(255, 0, 0)));
        this.mMessageLabel.setText(message);
    }

    public void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.mMessageLabel.setForeground(WorkbenchColors.getColor((RGB)new RGB(255, 0, 0)));
        this.mMessageLabel.setText(message);
    }

    public void setPageComplete(boolean complete) {
        this.getButton(0).setEnabled(complete);
    }

    public void setName(String newName) {
        this.mName = newName;
    }

    public String getName() {
        return this.mName;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setSourceRoot(IPackageFragmentRoot newRoot) {
        this.mSelectedRoot = newRoot;
    }

    public IPackageFragmentRoot getSourceRoot() {
        return this.mSelectedRoot;
    }

    public IPackageFragmentRoot[] getAllValidRoots() {
        return this.mAllValidRoots;
    }

    public Text getNameField() {
        return this.mNameField;
    }

    public Text getPackageField() {
        return this.mPackageField;
    }

    public Button getBrowsePackageButton() {
        return this.mBrowsePackageButton;
    }

    public List getSourcePathListField() {
        return this.mSourcePathList;
    }

    public Label getMessageLabel() {
        return this.mMessageLabel;
    }

    class BrowsePackageButtonListener
    implements MouseListener {
        BrowsePackageButtonListener() {
        }

        public void mouseUp(MouseEvent e) {
            IPackageFragment packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)WDCopyDialog.this.mSelectedRoot, (Shell)WDCopyDialog.this.getShell());
            if (packageFragment != null) {
                WDCopyDialog.this.mPackageField.setText(packageFragment.getElementName());
                WDCopyDialog.this.setPackage(packageFragment.getElementName());
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }
    }

    class SourceSelectionListener
    implements SelectionListener {
        SourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = WDCopyDialog.this.mSourcePathList.getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot selectedRoot = WDCopyDialog.this.mAllValidRoots[selectionIndex];
                WDCopyDialog.this.setSourceRoot(selectedRoot);
            }
        }
    }

    class PackageModifyListener
    implements ModifyListener {
        PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            WDCopyDialog.this.setPackage(WDCopyDialog.this.mPackageField.getText());
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            WDCopyDialog.this.setName(WDCopyDialog.this.mNameField.getText());
        }
    }
}

