/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ui.decorator;

import com.sap.ide.webdynpro.ui.UIPlugin;
import com.sap.ide.webdynpro.ui.decorator.DecoratedImageDescriptor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImageDecorator {
    public static final int POSITION_TOP_LEFT = 0;
    public static final int POSITION_TOP_RIGHT = 1;
    public static final int POSITION_BOTTOM_LEFT = 2;
    public static final int POSITION_BOTTOM_RIGHT = 3;
    private static Map mInstances = new Hashtable();
    private ImageRegistry mRegistry;

    public static ImageDecorator getInstance() {
        return ImageDecorator.getInstance(UIPlugin.getDefault().getImageRegistry());
    }

    public static ImageDecorator getInstance(ImageRegistry registry) {
        ImageDecorator instance = null;
        if (!mInstances.containsKey(registry)) {
            instance = new ImageDecorator(registry);
            mInstances.put(registry, instance);
        } else {
            instance = (ImageDecorator)mInstances.get(registry);
        }
        return instance;
    }

    private ImageDecorator(ImageRegistry registry) {
        this.mRegistry = registry;
    }

    public Image decorateWithError(Image baseImage) {
        return this.decorate(baseImage, 4);
    }

    public Image decorateWithWarning(Image baseImage) {
        return this.decorate(baseImage, 2);
    }

    public Image decorateWithInfo(Image baseImage) {
        return this.decorate(baseImage, 1);
    }

    public Image getGrayedImage(Image baseImage) {
        return this.getImage(baseImage, 2);
    }

    public Image getDisabledImage(Image baseImage) {
        return this.getImage(baseImage, 1);
    }

    public Image decorate(Image baseImage, int type) {
        Vector<Image> decorationImages = new Vector<Image>();
        Vector<Integer> decorationImageKeys = new Vector<Integer>();
        if (type == 4) {
            decorationImages.add(JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OVR_ERROR));
        } else if (type == 2) {
            decorationImages.add(JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OVR_WARNING));
        } else if (type == 1) {
            decorationImages.add(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        } else {
            throw new IllegalArgumentException("Unknown image type: " + type);
        }
        decorationImageKeys.add(new Integer(type));
        return this.getImage(baseImage, decorationImages, decorationImageKeys);
    }

    public Image decorate(Image baseImage, Image decorationImage, int position) {
        if (position < 0 || position > 3) {
            throw new IllegalArgumentException("Unknown position for image: " + position);
        }
        Vector<Image> decorationImages = new Vector<Image>();
        decorationImages.add(decorationImage);
        int[] imagePositions = new int[]{position};
        return this.getImage(baseImage, decorationImages, imagePositions);
    }

    private Image getImage(Image baseImage, List decorationImages, List decorationImageKeys) {
        String imageId = this.computeImageId(baseImage, decorationImageKeys);
        if (this.mRegistry.get(imageId) == null) {
            DecoratedImageDescriptor decoratedImageDescriptor = new DecoratedImageDescriptor(baseImage, decorationImages, decorationImageKeys);
            this.mRegistry.put(imageId, (ImageDescriptor)decoratedImageDescriptor);
        }
        return this.mRegistry.get(imageId);
    }

    private Image getImage(Image baseImage, List decorationImages, int[] positions) {
        Vector<Integer> imageKeys = new Vector<Integer>();
        int i = 0;
        while (i < positions.length) {
            int pos = positions[i];
            imageKeys.add(new Integer(pos));
            ++i;
        }
        String imageId = this.computeImageId(baseImage, imageKeys);
        if (this.mRegistry.get(imageId) == null) {
            DecoratedImageDescriptor decoratedImageDescriptor = new DecoratedImageDescriptor(baseImage, decorationImages, positions);
            this.mRegistry.put(imageId, (ImageDescriptor)decoratedImageDescriptor);
        }
        return this.mRegistry.get(imageId);
    }

    private Image getImage(Image baseImage, int style) {
        String imageId = this.computeImageId(baseImage, style);
        if (this.mRegistry.get(imageId) == null) {
            Image newImage = new Image((Device)Display.getCurrent(), baseImage, style);
            this.mRegistry.put(imageId, newImage);
        }
        return this.mRegistry.get(imageId);
    }

    private String computeImageId(Image baseImage, List decoratorKeys) {
        String separator = "_";
        StringBuffer id = new StringBuffer(Integer.toString(baseImage.hashCode()));
        Iterator iter = decoratorKeys.iterator();
        while (iter.hasNext()) {
            id.append("_");
            id.append((Integer)iter.next());
        }
        return id.toString();
    }

    private String computeImageId(Image baseImage, int style) {
        String separator = "_SWT_STYLE_";
        StringBuffer id = new StringBuffer(Integer.toString(baseImage.hashCode()));
        id.append("_SWT_STYLE_");
        id.append(style);
        return id.toString();
    }
}

