/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.ui.decorator;

import java.util.List;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecoratedImageDescriptor
extends CompositeImageDescriptor {
    private Image mBaseImage;
    private Point mSizeOfBaseImage;
    private List mImageKeys;
    private List mDecoratingImages;
    private int[] mImageLocations;
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;

    public DecoratedImageDescriptor(Image baseImage, List decorationImages, List imageKeys) {
        this.mBaseImage = baseImage;
        this.mDecoratingImages = decorationImages;
        this.mImageKeys = imageKeys;
        this.mSizeOfBaseImage = new Point(this.mBaseImage.getBounds().width, this.mBaseImage.getBounds().height);
    }

    public DecoratedImageDescriptor(Image baseImage, List decorationImages, int[] locations) {
        this.mBaseImage = baseImage;
        this.mDecoratingImages = decorationImages;
        this.mImageLocations = locations;
        this.mSizeOfBaseImage = new Point(this.mBaseImage.getBounds().width, this.mBaseImage.getBounds().height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.mBaseImage.getImageData(), 0, 0);
        if (this.mImageLocations == null || this.mImageLocations.length == 0) {
            this.mImageLocations = this.organizeImages(this.mImageKeys);
        }
        int i = 0;
        while (i < this.mImageLocations.length) {
            ImageData imageData = ((Image)this.mDecoratingImages.get(i)).getImageData();
            switch (this.mImageLocations[i]) {
                case 0: {
                    this.drawImage(imageData, 0, 0);
                    break;
                }
                case 1: {
                    this.drawImage(imageData, this.mSizeOfBaseImage.x - imageData.width, 0);
                    break;
                }
                case 2: {
                    this.drawImage(imageData, 0, this.mSizeOfBaseImage.y - imageData.height);
                    break;
                }
                case 3: {
                    this.drawImage(imageData, this.mSizeOfBaseImage.x - imageData.width, this.mSizeOfBaseImage.y - imageData.height);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a valid value for image location: " + this.mImageLocations[i]);
                }
            }
            ++i;
        }
    }

    private int[] organizeImages(List imageKeys) {
        int[] locations = new int[imageKeys.size()];
        int i = 0;
        while (i < this.mImageKeys.size()) {
            switch ((Integer)imageKeys.get(i)) {
                case 4: {
                    locations[i] = 2;
                    break;
                }
                case 2: {
                    locations[i] = 2;
                    break;
                }
                case 1: {
                    locations[i] = 0;
                    break;
                }
                case 0: {
                    locations[i] = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a valid value for status: " + (Integer)imageKeys.get(i));
                }
            }
            ++i;
        }
        return locations;
    }

    protected Point getSize() {
        return this.mSizeOfBaseImage;
    }
}

