/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web.registry;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceUniqueNameEnumeration;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.extension.ReferenceExistenceProvider;
import com.tssap.selena.model.extension.ReferenceParentProvider;
import com.tssap.selena.model.extension.ReferenceProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractWebRegistryContentProvider
extends AbstractWebProvider
implements ReferenceProvider,
ReferenceParentProvider,
ReferenceExistenceProvider,
ParentProvider {
    public boolean isReferenceProviderApplicable(ReferenceContainer container) {
        if (container instanceof ReferenceCollection) {
            return ((ReferenceCollection)container).getUniqueName().equals(this.getRegistry());
        }
        Reference reference = (Reference)container;
        String registryType = this.getRegistryType();
        return WebModelMetaInfo.isRegistryUniqueName((ReferenceUniqueName)reference.getUniqueName(), registryType);
    }

    public ReferenceUniqueNameEnumeration references(ReferenceContainer collection) {
        if (collection instanceof ReferenceCollection) {
            return this.topLevelChildren();
        }
        return this.references((Reference)collection);
    }

    private ReferenceUniqueNameEnumeration references(Reference reference) {
        HashSet result = new HashSet();
        return EnumerationConverter.toReferenceUniqueNameEnumeration(result.iterator());
    }

    private ReferenceUniqueNameEnumeration topLevelChildren() {
        HashSet<ReferenceUniqueName> result = new HashSet<ReferenceUniqueName>();
        String registryType = this.getRegistryType();
        Collection source = this.getTopLevelElements();
        Iterator it = source.iterator();
        while (it.hasNext()) {
            UniqueName nextUin;
            IWebElement next = (IWebElement)it.next();
            if (next == null || next.isImported() || (nextUin = WebModelMetaInfo.getUniqueName(next)) == null) continue;
            result.add(WebModelMetaInfo.getRegistryUniqueName(nextUin, registryType));
        }
        return EnumerationConverter.toReferenceUniqueNameEnumeration(result.iterator());
    }

    public ReferenceUniqueName getReferenceContainerUniqueName(Reference reference) {
        if (this.exists(reference.getUniqueName())) {
            // empty if block
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        if (uniqueName instanceof ReferenceUniqueName) {
            ReferenceUniqueName refUin = (ReferenceUniqueName)uniqueName;
            UniqueName referencedUniqueName = WebModelMetaInfo.getElementUniqueNameForRegistryEntry(refUin, this.getRegistryType());
            if (referencedUniqueName == null) {
                return false;
            }
            Element element = this.getModel().findElement(referencedUniqueName);
            if (element == null) {
                return false;
            }
            IWebElement we = this.getWebElement(referencedUniqueName);
            return we != null && !we.isImported();
        }
        return false;
    }

    protected IWebElement getWebElement(UniqueName uin) {
        ISourceWebElement swe = this.getSourceWebElement(uin);
        if (swe != null) {
            return swe;
        }
        return this.getJSP(uin);
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            return this.getRegistry();
        }
        return null;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return this.exists(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public void delete(Element element) {
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    public boolean canAddReference(ReferenceContainer container, Reference template, Entity entity) {
        return false;
    }

    public ReferenceUniqueName addReference(ReferenceContainer container, Reference template, Entity entity) {
        return null;
    }

    protected String getRegistryType() {
        return WebModelMetaInfo.getRegistryType(this.getRegistry());
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Reference template) {
        return false;
    }

    protected abstract UniqueName getRegistry();

    protected abstract Collection getTopLevelElements();
}

