/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.providers.web.WebPackageContentFactoryImpl;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContentFactory;
import com.tssap.selena.internal.core.providers.java.resources.PackageContentClipboard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class WebPlugin
extends Plugin {
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static WebPlugin ourInstance;

    public WebPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public void startup() throws CoreException {
        super.startup();
        PackageContentClipboard.registerFactory((IPackageContentFactory)new WebPackageContentFactoryImpl());
    }

    public static WebPlugin getDefault() {
        return ourInstance;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        WebPlugin instance = WebPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        WebPlugin.log(1, text);
    }

    public static void logError(String text) {
        WebPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        WebPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        WebPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        WebPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        WebPlugin instance = WebPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            WebPlugin.log(type, text, new Throwable());
        } else {
            WebPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        WebPlugin instance = WebPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

