/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.ICopiedSourceWebElement;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContent;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;

public class WebPackageFragmentContent
extends AbstractWebProvider
implements IPackageContent {
    private List myCopiedObjects;
    private boolean myWasCut;
    private List myOldWebObjectUins;
    private UniqueName myOriginalPackageUin;

    public WebPackageFragmentContent(IPackageFragment original, boolean updateExternalUsages) {
        Entity pack = this.getPackageEntity(original);
        this.registered(pack.getModel());
        this.myOriginalPackageUin = pack.getUniqueName();
        this.myCopiedObjects = new ArrayList(3);
        this.myOldWebObjectUins = new ArrayList(3);
        this.myWasCut = updateExternalUsages;
        EntityEnumeration children = pack.childEntities();
        while (children.hasMoreElements()) {
            Entity child = children.next();
            UniqueName nextUin = child.getUniqueName();
            ISourceWebElement sourceWebElement = this.getSourceWebElement(nextUin);
            if (sourceWebElement == null) continue;
            this.myOldWebObjectUins.add(nextUin);
            this.myCopiedObjects.add(this.getCopy(sourceWebElement));
        }
    }

    public boolean canPaste(IPackageFragment newPackageFragment) {
        return newPackageFragment != null && !newPackageFragment.isReadOnly() && newPackageFragment.exists();
    }

    public void paste(IPackageFragment newPackageFragment, Map collectedSubstitutionMap) {
        int i = 0;
        while (i < this.myCopiedObjects.size()) {
            ICopiedSourceWebElement copy = (ICopiedSourceWebElement)this.myCopiedObjects.get(i);
            UniqueName oldUin = (UniqueName)this.myOldWebObjectUins.get(i);
            ISourceWebElement pastedElement = this.getPaste(copy, newPackageFragment);
            if (this.myWasCut && pastedElement != null) {
                collectedSubstitutionMap.put(oldUin, this.getModel().findElement(WebModelMetaInfo.getUniqueName((IWebElement)pastedElement)));
            }
            ++i;
        }
    }

    private ICopiedSourceWebElement getCopy(ISourceWebElement element) {
        try {
            if (this.myWasCut) {
                if (element.canCut(true)) {
                    return element.cut(true);
                }
            } else if (element.canCopy(true)) {
                return element.copy(true);
            }
        }
        catch (WebModelException e) {
            WebPlugin.logWarning("Failed to copy web object", e);
        }
        return null;
    }

    private ISourceWebElement getPaste(ICopiedSourceWebElement copy, IPackageFragment pf) {
        try {
            return copy.paste(pf);
        }
        catch (WebModelException e) {
            return null;
        }
    }

    private Entity getPackageEntity(IPackageFragment packageFragment) {
        UniqueName packageUin = NameUtil.getPackageUniqueName((IPackageFragment)packageFragment);
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)packageFragment.getJavaProject().getProject());
        Model model = ModelAccess.getModel((UniqueName)modelUin);
        return model.findEntity(packageUin);
    }
}

