/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.utils.JdtModelUtils;
import com.tssap.j2ee.core.web.ICopiedSourceWebElement;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.PasteProvider;
import java.util.HashMap;
import org.eclipse.jdt.core.IPackageFragment;

public class WebObjectCopyPasteProvider
extends AbstractWebProvider
implements CopyProvider,
CutProvider,
PasteProvider,
EntityExistenceProvider {
    private HashMap myClipboardUins2Elements;

    public boolean isCopyProviderApplicable(Element element) {
        return true;
    }

    public boolean canCopy(Element element) {
        ISourceWebElement source = this.getSourceWebElement(element.getUniqueName());
        if (source == null) {
            return false;
        }
        return source.canCopy(false);
    }

    public void copy(Element element, CopyUniqueName copyUniqueName) {
        ISourceWebElement source = this.getSourceWebElement(element.getUniqueName());
        try {
            ICopiedSourceWebElement copy = source.copy(false);
            this.myClipboardUins2Elements.put(copyUniqueName, copy);
        }
        catch (WebModelException e) {
            WebPlugin.logWarning("Failed to copy web content element", e);
        }
    }

    public boolean isCutProviderApplicable(Element element) {
        return true;
    }

    public boolean canCut(Element element) {
        ISourceWebElement source = this.getSourceWebElement(element.getUniqueName());
        if (source == null) {
            return false;
        }
        return source.canCut(false);
    }

    public void cut(Element element, CopyUniqueName cutUniqueName) {
        ISourceWebElement source = this.getSourceWebElement(element.getUniqueName());
        try {
            ICopiedSourceWebElement cut = source.cut(false);
            this.myClipboardUins2Elements.put(cutUniqueName, cut);
        }
        catch (WebModelException e) {
            WebPlugin.logWarning("Failed to cut web content element", e);
        }
    }

    public boolean isPasteProviderApplicable(Entity container) {
        return true;
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        IPackageFragment pf = JdtModelUtils.getPackage((Element)container);
        if (pf == null) {
            return false;
        }
        UniqueName pasteUin = element.getUniqueName();
        ICopiedSourceWebElement copy = (ICopiedSourceWebElement)this.myClipboardUins2Elements.get(pasteUin);
        return copy != null && copy.canPaste(pf);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        IPackageFragment pf = JdtModelUtils.getPackage((Element)container);
        UniqueName pasteUin = element.getUniqueName();
        ICopiedSourceWebElement copy = (ICopiedSourceWebElement)this.myClipboardUins2Elements.get(pasteUin);
        try {
            ISourceWebElement result = copy.paste(pf);
            return WebModelMetaInfo.getUniqueName((IWebElement)result);
        }
        catch (WebModelException e) {
            return null;
        }
    }

    public boolean exists(UniqueName uniqueName) {
        return this.myClipboardUins2Elements.containsKey(uniqueName);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element.getUniqueName() instanceof CopyUniqueName;
    }

    public boolean canDelete(Element element) {
        return this.exists(element.getUniqueName());
    }

    public void delete(Element element) {
        ICopiedSourceWebElement copy = (ICopiedSourceWebElement)this.myClipboardUins2Elements.remove(element.getUniqueName());
        try {
            copy.delete(null);
        }
        catch (WebModelException e) {
            WebPlugin.logWarning("Failed to clean up the copied web object", e);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myClipboardUins2Elements = null;
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardUins2Elements = new HashMap();
    }
}

