/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;

public class WebModelAccess {
    private WebModelAccess() {
    }

    public static WebProject getWebProject(Model model) {
        if (model == null || model.isDeleted()) {
            return null;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project == null || !project.isAccessible()) {
            return null;
        }
        return WebProject.getInstance((IProject)project);
    }

    public static IServlet getServlet(Model model, UniqueName uin) {
        String packageName = uin.getLocation();
        String name = uin.getName();
        WebProject webProject = WebModelAccess.getWebProject(model);
        return webProject.getServlet(WebModelAccess.getFqn(packageName, name));
    }

    public static IFilter getFilter(Model model, UniqueName uin) {
        String packageName = uin.getLocation();
        String name = uin.getName();
        WebProject webProject = WebModelAccess.getWebProject(model);
        return webProject.getFilter(WebModelAccess.getFqn(packageName, name));
    }

    private static String getFqn(String packageName, String className) {
        if (packageName.length() == 0) {
            return className;
        }
        return packageName + '.' + className;
    }
}

