/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;

public class WebMethodProvider
extends AbstractWebProvider
implements EntityExistenceProvider {
    private static final Collection FILTER_METHOD_NAMES = new HashSet();
    private static final Collection GENERIC_SERVLET_METHOD_NAMES = new HashSet();
    private static final Collection HTTP_SERVLET_METHOD_NAMES = new HashSet();

    public boolean exists(UniqueName uniqueName) {
        IWebMethod method = this.getWebMethod(uniqueName);
        return method != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.web.WebMethod".equals(shapeType)) {
            return false;
        }
        if (template == null) {
            return false;
        }
        UniqueName parentUin = parent.getUniqueName();
        if (WebModelMetaInfo.isFilterUniqueName(parentUin)) {
            return this.canCreateFilterMethod(this.getFilter(parentUin), template);
        }
        if (WebModelMetaInfo.isServletUniqueName(parentUin)) {
            return this.canCreateServletMethod(this.getServlet(parentUin), template);
        }
        return false;
    }

    private boolean canCreateFilterMethod(IFilter parent, Entity template) {
        if (parent == null) {
            return false;
        }
        String name = template.getPropertyValue("$name");
        if (name == null) {
            return false;
        }
        if (parent.getMethod(name) != null) {
            return false;
        }
        return FILTER_METHOD_NAMES.contains(name);
    }

    private boolean canCreateServletMethod(IServlet parent, Entity template) {
        if (parent == null) {
            return false;
        }
        String name = template.getPropertyValue("$name");
        if (name == null) {
            return false;
        }
        if (parent.getMethod(name) != null) {
            return false;
        }
        if (GENERIC_SERVLET_METHOD_NAMES.contains(name)) {
            return true;
        }
        if (HTTP_SERVLET_METHOD_NAMES.contains(name)) {
            return parent.isHttpServlet();
        }
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUin = parent.getUniqueName();
        if (WebModelMetaInfo.isFilterUniqueName(parentUin)) {
            return this.createFilterMethod(this.getFilter(parentUin), template.getPropertyValue("$name"));
        }
        if (WebModelMetaInfo.isServletUniqueName(parentUin)) {
            return this.createServletMethod(this.getServlet(parentUin), template.getPropertyValue("$name"));
        }
        return null;
    }

    private UniqueName createFilterMethod(IFilter filter, String name) {
        try {
            IWebMethod createdMethod = filter.createMethod(name, (IProgressMonitor)new NullProgressMonitor());
            if (createdMethod == null) {
                return null;
            }
            return WebModelMetaInfo.getUniqueName(createdMethod);
        }
        catch (WebModelException e) {
            WebPlugin.logError("Exception occurred while trying to create method", e);
            return null;
        }
    }

    private UniqueName createServletMethod(IServlet servlet, String name) {
        try {
            IWebMethod createdMethod = servlet.createServletMethod(name, (IProgressMonitor)new NullProgressMonitor());
            if (createdMethod == null) {
                return null;
            }
            return WebModelMetaInfo.getUniqueName(createdMethod);
        }
        catch (WebModelException e) {
            WebPlugin.logError("Exception occurred while trying to create method", e);
            return null;
        }
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return WebModelMetaInfo.isWebMethodUniqueName(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        IWebMethod method = this.getWebMethod(element.getUniqueName());
        if (method == null) {
            return false;
        }
        IMethod jdtMethod = method.getMethod();
        return jdtMethod != null && jdtMethod.exists() && !jdtMethod.isBinary();
    }

    public void delete(Element element) {
        IWebMethod method = this.getWebMethod(element.getUniqueName());
        try {
            method.delete((IProgressMonitor)new NullProgressMonitor());
        }
        catch (WebModelException e) {
            e.printStackTrace();
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    static {
        FILTER_METHOD_NAMES.add("init");
        FILTER_METHOD_NAMES.add("destroy");
        FILTER_METHOD_NAMES.add("doFilter");
        GENERIC_SERVLET_METHOD_NAMES.add("init");
        GENERIC_SERVLET_METHOD_NAMES.add("destroy");
        GENERIC_SERVLET_METHOD_NAMES.add("service");
        HTTP_SERVLET_METHOD_NAMES.add("doGet");
        HTTP_SERVLET_METHOD_NAMES.add("doPost");
        HTTP_SERVLET_METHOD_NAMES.add("doHead");
        HTTP_SERVLET_METHOD_NAMES.add("doPut");
        HTTP_SERVLET_METHOD_NAMES.add("doDelete");
        HTTP_SERVLET_METHOD_NAMES.add("doOptions");
        HTTP_SERVLET_METHOD_NAMES.add("doTrace");
    }
}

