/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.enum.SingleEnumeration;
import java.util.Enumeration;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class WebMethodObjectPropertyProvider
extends AbstractWebProvider
implements ObjectPropertyProvider {
    public Object getObjectPropertyValue(Element element, String propertyName) {
        IWebMethod webMethod = this.getWebMethod(element.getUniqueName());
        if (webMethod == null) {
            return null;
        }
        IMethod method = webMethod.getMethod();
        if ("org.eclipse.jdt.core.IMethod".equals(propertyName)) {
            return method;
        }
        if ("parameterArray".equals(propertyName)) {
            String[] parameterTypes = method.getParameterTypes();
            return JDTUtils.jdt2java((String[])parameterTypes);
        }
        if ("parameterNameArray".equals(propertyName)) {
            try {
                String[] parameterTypes = JDTUtils.jdt2java((String[])method.getParameterTypes());
                String[] parameterNames = method.getParameterNames();
                String[] result = new String[parameterTypes.length + parameterNames.length];
                int i = 0;
                int j = 0;
                while (i < parameterTypes.length) {
                    result[j] = parameterTypes[i];
                    result[j + 1] = parameterNames[i];
                    ++i;
                    j += 2;
                }
                return result;
            }
            catch (JavaModelException e) {
                this.log(e);
                return null;
            }
        }
        if ("exceptionArray".equals(propertyName)) {
            try {
                String[] exceptionTypes = method.getExceptionTypes();
                return JDTUtils.jdt2java((String[])exceptionTypes);
            }
            catch (JavaModelException e) {
                this.log(e);
                return null;
            }
        }
        return null;
    }

    private void log(JavaModelException e) {
        WebPlugin.logError("Exception while accessing Java information", e);
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        Object result = this.getObjectPropertyValue(element, propertyName);
        if (result == null) {
            return EmptyEnumeration.getEnumeration();
        }
        return new SingleEnumeration(result);
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }
}

