/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementDelta;
import com.tssap.j2ee.core.web.IWebModelListener;
import com.tssap.j2ee.core.web.WebModelChangedEvent;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import com.tssap.selena.model.util.various.DeltaDumper;
import java.util.HashSet;

public class WebDeltaProvider
extends AbstractWebProvider
implements DeltaTreeProvider,
IWebModelListener {
    private RootModelDeltaNode myRootDelta;
    private HashSet myProcessedUniqueNames;

    public void registered(Model model) {
        super.registered(model);
        this.initialize();
        this.getProject().addWebModelListener((IWebModelListener)this);
    }

    public void unregistered(Model model) {
        this.getProject().removeWebModelListener((IWebModelListener)this);
        super.unregistered(model);
    }

    public synchronized void webModelChanged(WebModelChangedEvent evt) {
        IWebElementDelta delta = evt.getDelta();
        this.processDelta(delta);
        this.getModel().getExtensionManager().modelContentsChanged();
    }

    public synchronized ModelDeltaNode getModelChanges() {
        if (this.myRootDelta.isEmpty()) {
            return null;
        }
        RootModelDeltaNode result = this.myRootDelta;
        if (WebPlugin.getDefault().isDebuggingDelta()) {
            DeltaDumper.dumpDelta((ModelDeltaNode)result);
        }
        this.initialize();
        return result;
    }

    private void processDelta(IWebElementDelta delta) {
        IWebElement[][] renamed = delta.getRenamedElements();
        int i = 0;
        while (i < renamed[0].length) {
            IWebElement added;
            UniqueName addedUin;
            IWebElement removed = renamed[0][i];
            UniqueName removedUin = WebModelMetaInfo.getUniqueName(removed);
            if (!(WebDeltaProvider.equalsEx(removedUin, addedUin = WebModelMetaInfo.getUniqueName(added = renamed[1][i])) || this.myProcessedUniqueNames.contains(addedUin) || this.myProcessedUniqueNames.contains(removedUin))) {
                this.myProcessedUniqueNames.add(removedUin);
                this.myProcessedUniqueNames.add(addedUin);
                if (removedUin != null) {
                    this.myRootDelta.addDeltaNode((TreeModelDeltaNode)new RenamedModelDeltaNode(this.getModel(), removedUin, ModelDeltaNodeKind.DELETED, removed, addedUin));
                    this.addRegistryDeltaNode(removed);
                }
                if (addedUin != null) {
                    this.myRootDelta.addDeltaNode((TreeModelDeltaNode)new RenamedModelDeltaNode(this.getModel(), addedUin, ModelDeltaNodeKind.NEW, added, removedUin));
                    this.addRegistryDeltaNode(added);
                }
            }
            ++i;
        }
        IWebElement[] removedElements = delta.getRemovedElements();
        int i2 = 0;
        while (i2 < removedElements.length) {
            IWebElement removed = removedElements[i2];
            UniqueName removedUin = WebModelMetaInfo.getUniqueName(removed);
            if (!this.myProcessedUniqueNames.contains(removedUin)) {
                this.myProcessedUniqueNames.add(removedUin);
                this.myRootDelta.addDeltaNode((TreeModelDeltaNode)new ParentAwareModelDeltaNode(this.getModel(), removedUin, ModelDeltaNodeKind.DELETED, removed));
                this.addRegistryDeltaNode(removed);
            }
            ++i2;
        }
        IWebElement[] addedElements = delta.getAddedElements();
        int i3 = 0;
        while (i3 < addedElements.length) {
            IWebElement added = addedElements[i3];
            UniqueName addedUin = WebModelMetaInfo.getUniqueName(added);
            if (!this.myProcessedUniqueNames.contains(addedUin)) {
                this.myProcessedUniqueNames.add(addedUin);
                this.myRootDelta.addDeltaNode((TreeModelDeltaNode)new ParentAwareModelDeltaNode(this.getModel(), addedUin, ModelDeltaNodeKind.NEW, added));
                this.addRegistryDeltaNode(added);
            }
            ++i3;
        }
        IWebElement[] changedElements = delta.getChangedElements();
        int i4 = 0;
        while (i4 < changedElements.length) {
            IWebElement changed = changedElements[i4];
            UniqueName changedUin = WebModelMetaInfo.getUniqueName(changed);
            if (!this.myProcessedUniqueNames.contains(changedUin)) {
                this.myRootDelta.addDeltaNode((TreeModelDeltaNode)new ParentAwareModelDeltaNode(this.getModel(), changedUin, ModelDeltaNodeKind.CHANGED, changed));
                this.addRegistryDeltaNode(changed);
            }
            ++i4;
        }
    }

    private void addRegistryDeltaNode(IWebElement element) {
        TreeModelDeltaNode registryNode = this.createRegistryDeltaNode(element);
        if (registryNode != null) {
            this.myRootDelta.addDeltaNode(registryNode);
        }
    }

    private TreeModelDeltaNode createRegistryDeltaNode(IWebElement element) {
        UniqueName registry = WebModelMetaInfo.getRegistryForElement(element);
        if (registry != null) {
            return new DefaultModelDeltaNode(this.getModel(), registry, ModelDeltaNodeKind.CHANGED);
        }
        return null;
    }

    private static boolean equalsEx(UniqueName removedUin, UniqueName addedUin) {
        if (removedUin == null) {
            return addedUin == null;
        }
        return removedUin.equals(addedUin);
    }

    private void initialize() {
        this.myRootDelta = new RootModelDeltaNode(this.getModel());
        this.myProcessedUniqueNames = new HashSet();
        this.myProcessedUniqueNames.add(null);
    }

    private class RenamedModelDeltaNode
    extends ParentAwareModelDeltaNode {
        private UniqueName myOriginalUin;

        public RenamedModelDeltaNode(Model model, UniqueName uniqueName, ModelDeltaNodeKind kind, IWebElement element, UniqueName originalUin) {
            super(model, uniqueName, kind, element);
            this.myOriginalUin = originalUin;
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myOriginalUin == null ? super.getOriginalElementUniqueName() : this.myOriginalUin;
        }
    }

    private class ParentAwareModelDeltaNode
    extends DefaultModelDeltaNode {
        private IWebElement myElement;

        public ParentAwareModelDeltaNode(Model model, UniqueName uniqueName, ModelDeltaNodeKind kind, IWebElement element) {
            super(model, uniqueName, kind);
            this.myElement = element;
        }

        public UniqueName getParentUniqueName() {
            return WebDeltaProvider.this.getParentUniqueName(this.myElement);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DefaultModelDeltaNode)) {
                return false;
            }
            DefaultModelDeltaNode other = (DefaultModelDeltaNode)object;
            return this.getElementUniqueName().equals(other.getElementUniqueName());
        }

        public int hashCode() {
            return this.getElementUniqueName().hashCode();
        }
    }
}

