/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WebContentProvider
extends AbstractWebProvider
implements ChildrenProvider,
EntityExistenceProvider,
ParentProvider {
    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName parentUin = parent.getUniqueName();
        if (WebContentProvider.isProjectModelUniqueName(parentUin)) {
            return true;
        }
        return "com.tssap.j2ee.core.web.WebContent".equals(parent.getPropertyValue("$metaclass"));
    }

    public UniqueNameEnumeration children(Entity parent) {
        UniqueName parentUin = parent.getUniqueName();
        ArrayList<UniqueName> uins = new ArrayList<UniqueName>();
        if (WebContentProvider.isProjectModelUniqueName(parentUin)) {
            String projectName = parentUin.getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                IResource[] children = project.members();
                int i = 0;
                while (i < children.length) {
                    String fName;
                    IResource child = children[i];
                    if (child instanceof IFolder && "webContent".equals(fName = child.getName())) {
                        uins.add(WebContentProvider.createUin(child));
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        } else {
            IResource resource;
            Path parentPath = new Path(parentUin.getLocation());
            if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)parentPath) && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)parentPath)) != null && resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] children = container.members();
                    int i = 0;
                    while (i < children.length) {
                        IResource child = children[i];
                        if (!"jsp".equals(child.getFileExtension())) {
                            uins.add(WebContentProvider.createUin(child));
                        }
                        ++i;
                    }
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(uins));
    }

    static UniqueName createUin(IPath path, String subDomain) {
        return WebModelMetaInfo.getWebContentElementUniqueName(path, subDomain);
    }

    static UniqueName createUin(IResource resource) {
        return WebModelMetaInfo.getWebContentElementUniqueName(resource);
    }

    static boolean isProjectModelUniqueName(UniqueName uName) {
        boolean ret = false;
        if (uName != null) {
            boolean isModelDomain = uName.getDomain().equals("model");
            boolean isProjectSubDomain = uName.getSubDomain().equals("project");
            ret = isModelDomain && isProjectSubDomain;
        }
        return ret;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.web.WebContent".equals(parent.getPropertyValue("$metaclass"))) {
            return false;
        }
        return "com.tssap.j2ee.core.web.JSP".equals(shapeType) || "com.tssap.j2ee.core.web.WebContent".equals(shapeType) || "com.tssap.j2ee.core.web.Resource".equals(shapeType) || "com.tssap.j2ee.core.web.HTML".equals(shapeType);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IResource parentResource = this.getResource((Element)parent);
        if (parentResource == null) {
            return null;
        }
        if (template == null || template.hasProperty("$nametemplate")) {
            if (template == null) {
                template = parent.getModel().createEntityTemplate();
            }
            template.setPropertyValue("$name", this.getNewName(parent, shapeType, template.getPropertyValue("$nametemplate")));
        } else if (!template.hasProperty("$name")) {
            template.setPropertyValue("$name", this.getNewName(parent, shapeType, template.getPropertyValue("$nametemplate")));
        }
        String childResourceName = template.getPropertyValue("$name");
        UniqueName newUin = null;
        if ("com.tssap.j2ee.core.web.WebContent".equals(shapeType)) {
            Path childResourcePath = new Path(childResourceName);
            IFolder childResource = ((IContainer)parentResource).getFolder((IPath)childResourcePath);
            try {
                childResource.create(true, true, null);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            newUin = WebContentProvider.createUin((IResource)childResource);
        } else if ("com.tssap.j2ee.core.web.JSP".equals(shapeType)) {
            Path childResourcePath = new Path(childResourceName + "." + "jsp");
            IFile childResource = ((IContainer)parentResource).getFile((IPath)childResourcePath);
            IJSP jsp = null;
            try {
                jsp = WebProject.getInstance((IProject)parentResource.getProject()).createJSP(childResource, null);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (jsp != null) {
                newUin = WebModelMetaInfo.getJSPUniqueName(jsp.getFile());
            }
        } else if ("com.tssap.j2ee.core.web.HTML".equals(shapeType)) {
            Path childResourcePath = new Path(childResourceName + "." + "html");
            IFile childResource = ((IContainer)parentResource).getFile((IPath)childResourcePath);
            String html = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n\r<HTML>\n\r<HEAD>\n\r<TITLE> New Document </TITLE>\n\r<META NAME=\"Generator\" CONTENT=\"TSSAP HTML Generator\">\n\r<META NAME=\"Author\" CONTENT=\"\">\n\r<META NAME=\"Keywords\" CONTENT=\"\">\n\r<META NAME=\"Description\" CONTENT=\"\">\n\r</HEAD>\n\r<BODY BGCOLOR=\"#FFFFFF\">\n\r</BODY>\n\r</HTML>";
            ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
            try {
                childResource.create((InputStream)is, true, null);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            newUin = WebContentProvider.createUin((IResource)childResource);
        }
        return newUin;
    }

    private String getNewName(Entity parent, String shapeType, String preferredName) {
        int dotIndex;
        if (preferredName == null && (dotIndex = (preferredName = shapeType).lastIndexOf(46)) != -1) {
            preferredName = preferredName.substring(dotIndex + 1);
        }
        HashSet<String> namesInUse = new HashSet<String>();
        EntityEnumeration children = parent.childEntities();
        while (children.hasMoreElements()) {
            String nextName;
            Entity child = children.next();
            String nextMetaclass = child.getPropertyValue("$metaclass");
            if (!nextMetaclass.equals(shapeType) || (nextName = child.getPropertyValue("$name")) == null || !nextName.startsWith(preferredName)) continue;
            namesInUse.add(nextName);
        }
        int nameSuffix = 1;
        String name;
        while (namesInUse.contains(name = preferredName + nameSuffix)) {
            ++nameSuffix;
        }
        return name;
    }

    public boolean exists(UniqueName uniqueName) {
        return this.getResource(uniqueName) != null;
    }

    public boolean canDelete(Element element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return false;
        }
        return resource.getType() != 2 || resource.getProjectRelativePath().segmentCount() != 1;
    }

    public void delete(Element element) {
        IResource resource = this.getResource(element);
        if (resource != null) {
            try {
                resource.delete(3, null);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
    }

    public boolean isDeleted(Element element) {
        UniqueName elementUin = element.getUniqueName();
        return !this.exists(elementUin);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return true;
    }

    public UniqueName getParentUniqueName(Element child) {
        String childMetaclass = child.getPropertyValue("$metaclass");
        if (!("com.tssap.j2ee.core.web.WebContent".equals(childMetaclass) || "com.tssap.j2ee.core.web.HTML".equals(childMetaclass) || "com.tssap.j2ee.core.web.Resource".equals(childMetaclass))) {
            return null;
        }
        IResource childResource = this.getResource(child);
        if (childResource == null) {
            return null;
        }
        IContainer parentResource = childResource.getParent();
        if (parentResource == null) {
            return null;
        }
        if (parentResource instanceof IProject) {
            return child.getModel().getUniqueName();
        }
        return WebContentProvider.createUin((IResource)parentResource);
    }
}

