/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebContentProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import com.tssap.selena.model.util.various.DeltaDumper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class WebContentDeltaProvider
extends AbstractWebProvider
implements DeltaTreeProvider,
IResourceChangeListener {
    private IResourceDeltaVisitor myDeltaVisitor = new WebContentDeltaVisitor();
    private RootModelDeltaNode myRootDeltaNode;

    public WebContentDeltaProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        if (this.getProject() == null) {
            return;
        }
        IProject project = this.getProject().getProject();
        if (project == null || !project.isAccessible()) {
            return;
        }
        int eventType = event.getType();
        if ((eventType & 6) > 0 || (eventType & 1) == 0) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            if (this.myRootDeltaNode == null) {
                this.myRootDeltaNode = new RootModelDeltaNode(this.getModel());
            }
            delta.accept(this.myDeltaVisitor);
            if (!this.myRootDeltaNode.isEmpty()) {
                this.getModel().getExtensionManager().modelContentsChanged();
            }
        }
        catch (CoreException visitorNotAccepted) {
            System.err.println("delta can not accept delta-visitor: " + (Object)((Object)visitorNotAccepted));
            return;
        }
    }

    public synchronized ModelDeltaNode getModelChanges() {
        if (this.myRootDeltaNode == null || this.myRootDeltaNode.isEmpty()) {
            return null;
        }
        RootModelDeltaNode retNode = this.myRootDeltaNode;
        this.myRootDeltaNode = null;
        if (WebPlugin.getDefault().isDebuggingDelta()) {
            DeltaDumper.dumpDelta((ModelDeltaNode)retNode);
        }
        return retNode;
    }

    private class WebContentDeltaNode
    extends DefaultModelDeltaNode {
        private UniqueName myOriginalUin;
        private IResource myResource;

        public WebContentDeltaNode(IResource resource, ModelDeltaNodeKind kind, IResource originalResource) {
            super(WebContentDeltaProvider.this.getModel(), WebContentProvider.createUin(resource), kind);
            this.myOriginalUin = originalResource == null ? null : WebContentProvider.createUin(originalResource);
            this.myResource = resource;
        }

        public UniqueName getParentUniqueName() {
            IContainer parentResource = this.myResource.getParent();
            if (parentResource.getType() == 4) {
                return this.getModel().getUniqueName();
            }
            return WebContentProvider.createUin((IResource)parentResource);
        }

        public UniqueName getOriginalElementUniqueName() {
            if (this.myOriginalUin == null || WebContentDeltaProvider.this.getProject() == null || WebContentDeltaProvider.this.getProject().getProject() == null) {
                return super.getOriginalElementUniqueName();
            }
            return this.myOriginalUin;
        }
    }

    private class WebContentDeltaVisitor
    implements IResourceDeltaVisitor {
        private WebContentDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource changedResource = delta.getResource();
            IPath resourcePath = changedResource.getProjectRelativePath();
            switch (changedResource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return changedResource.equals((Object)WebContentDeltaProvider.this.getProject().getProject());
                }
                case 2: {
                    if (!"webContent".equals(resourcePath.segment(0))) {
                        return false;
                    }
                    return this.visitFolder(delta, (IFolder)changedResource);
                }
                case 1: {
                    if (!"webContent".equals(resourcePath.segment(0))) {
                        return false;
                    }
                    return this.visitFile(delta, (IFile)changedResource);
                }
            }
            return false;
        }

        private boolean visitFolder(IResourceDelta delta, IFolder folder) {
            switch (delta.getKind()) {
                case 1: {
                    IFolder original = (delta.getFlags() & 0x1000) != 0 ? folder.getWorkspace().getRoot().getFolder(delta.getMovedFromPath()) : null;
                    WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)folder, ModelDeltaNodeKind.NEW, (IResource)original));
                    break;
                }
                case 2: {
                    IFolder original = (delta.getFlags() & 0x2000) != 0 ? folder.getWorkspace().getRoot().getFolder(delta.getMovedToPath()) : null;
                    WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)folder, ModelDeltaNodeKind.DELETED, (IResource)original));
                }
                case 4: {
                    if ((delta.getFlags() & 0x40000) != 0) {
                        WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)folder, ModelDeltaNodeKind.TOTALLY_CHANGED, null));
                    } else if ((delta.getFlags() & 0x8000) != 0) {
                        IFile oldState = folder.getWorkspace().getRoot().getFile(folder.getFullPath());
                        WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)oldState, ModelDeltaNodeKind.DELETED, null));
                        WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)folder, ModelDeltaNodeKind.NEW, null));
                    }
                    return true;
                }
                default: {
                    return true;
                }
            }
            return true;
        }

        private boolean visitFile(IResourceDelta delta, IFile file) {
            switch (delta.getKind()) {
                case 1: {
                    IFile original = (delta.getFlags() & 0x1000) != 0 ? file.getWorkspace().getRoot().getFile(delta.getMovedFromPath()) : null;
                    WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)file, ModelDeltaNodeKind.NEW, (IResource)original));
                    break;
                }
                case 2: {
                    IFile original = (delta.getFlags() & 0x2000) != 0 ? file.getWorkspace().getRoot().getFile(delta.getMovedToPath()) : null;
                    WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)file, ModelDeltaNodeKind.DELETED, (IResource)original));
                }
                case 4: {
                    if ((delta.getFlags() & 0x40000) != 0) {
                        WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)file, ModelDeltaNodeKind.TOTALLY_CHANGED, null));
                    } else if ((delta.getFlags() & 0x8000) != 0) {
                        IFolder oldState = file.getWorkspace().getRoot().getFolder(file.getFullPath());
                        WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)oldState, ModelDeltaNodeKind.DELETED, null));
                        WebContentDeltaProvider.this.myRootDeltaNode.addDeltaNode((TreeModelDeltaNode)new WebContentDeltaNode((IResource)file, ModelDeltaNodeKind.NEW, null));
                    }
                    return true;
                }
                default: {
                    return true;
                }
            }
            return true;
        }
    }
}

