/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.utils.ParametrizedHashBag;
import com.tssap.j2ee.core.utils.clipboard.ClipboardElement;
import com.tssap.j2ee.core.utils.clipboard.ModelClipboard;
import com.tssap.j2ee.core.webapp.AssembledInfoFinder;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.PasteProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.UinEscaper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WebContentCopyPasteProvider
extends AbstractWebProvider
implements CopyProvider,
CutProvider,
PasteProvider,
EntityExistenceProvider {
    private HashMap myClipboardUins2Elements;

    public boolean isCopyProviderApplicable(Element element) {
        return true;
    }

    public boolean canCopy(Element element) {
        IResource resource = this.getResource(element);
        if (resource == null || !resource.exists()) {
            return false;
        }
        return resource.getParent().getType() != 4;
    }

    public void copy(Element element, CopyUniqueName copyUniqueName) {
        IResource resource = this.getResource(element);
        CopyingVisitor copy = new CopyingVisitor(resource, false);
        try {
            resource.accept((IResourceVisitor)copy);
        }
        catch (CoreException e) {
            WebPlugin.logWarning("Failed to copy web content element", e);
        }
        this.myClipboardUins2Elements.put(copyUniqueName, copy);
    }

    public boolean isCutProviderApplicable(Element element) {
        return true;
    }

    public boolean canCut(Element element) {
        IResource resource = this.getResource(element);
        if (resource == null || !resource.exists()) {
            return false;
        }
        if (resource.getParent().getType() == 4) {
            return false;
        }
        final boolean[] resultHolder = new boolean[]{true};
        try {
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!resultHolder[0]) {
                        return false;
                    }
                    if (resource.isReadOnly()) {
                        resultHolder[0] = false;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            return false;
        }
        return resultHolder[0];
    }

    public void cut(Element element, CopyUniqueName cutUniqueName) {
        IResource resource = this.getResource(element);
        CopyingVisitor copy = new CopyingVisitor(resource, true);
        try {
            resource.accept((IResourceVisitor)copy);
            resource.delete(3, null);
        }
        catch (CoreException e) {
            WebPlugin.logWarning("Failed to delete web content element", e);
        }
        this.myClipboardUins2Elements.put(cutUniqueName, copy);
    }

    public boolean isPasteProviderApplicable(Entity container) {
        return true;
    }

    public boolean canPaste(Entity containerAsEntity, Element element, Element anchor, boolean before) {
        IResource container = this.getResource((Element)containerAsEntity);
        if (container == null || container.getType() != 2) {
            return false;
        }
        UniqueName pasteUin = element.getUniqueName();
        CopyingVisitor copy = (CopyingVisitor)this.myClipboardUins2Elements.get(pasteUin);
        return copy != null && copy.canPaste((IFolder)container);
    }

    public UniqueName paste(Entity containerAsEntity, Element element, Element createdElement, Element anchor, boolean before) {
        IResource container = this.getResource((Element)containerAsEntity);
        UniqueName pasteUin = element.getUniqueName();
        CopyingVisitor copy = (CopyingVisitor)this.myClipboardUins2Elements.get(pasteUin);
        IResource pasted = copy.paste((IFolder)container);
        if (pasted == null) {
            return null;
        }
        return WebModelMetaInfo.getWebContentElementUniqueName(pasted);
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return this.myClipboardUins2Elements.containsKey(uniqueName);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element.getUniqueName() instanceof CopyUniqueName;
    }

    public boolean canDelete(Element element) {
        return this.exists(element.getUniqueName());
    }

    public void delete(Element element) {
        CopyingVisitor removed = (CopyingVisitor)this.myClipboardUins2Elements.remove(element.getUniqueName());
        removed.delete();
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myClipboardUins2Elements = null;
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardUins2Elements = new HashMap();
    }

    private class CopyingVisitor
    implements IResourceVisitor {
        private HashMap myContents = new HashMap();
        private HashMap myJSPs2AssembledServletCopies = new HashMap();
        private IPath myRoot;
        private HashSet myFolders = new HashSet();
        private boolean myRootIsFile;
        private boolean myIsCutting;
        static /* synthetic */ Class class$java$util$ArrayList;

        public CopyingVisitor(IResource root, boolean isCutting) {
            this.myRoot = root.getFullPath();
            this.myIsCutting = isCutting;
            this.myRootIsFile = root.getType() == 1;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() != 1) {
                this.myFolders.add(this.getPath(resource));
                return true;
            }
            byte[] fileContents = FileUtils.getFileBytes((IFile)((IFile)resource));
            this.myContents.put(this.getPath(resource), fileContents);
            if ("jsp".equals(resource.getFileExtension())) {
                this.processJSP((IFile)resource);
            }
            return true;
        }

        private void processJSP(IFile jsp) {
            Servlet[] assembled = AssembledInfoFinder.findAssembledJSPs((IFile)jsp);
            if (assembled == null) {
                return;
            }
            int i = 0;
            while (i < assembled.length) {
                Entity next = this.getAssembledJSP(assembled[i], jsp);
                if (next != null) {
                    this.getAssembledServletCopies(this.getPath((IResource)jsp)).add((Object)next.getParent(), (Object)this.copyOrCut(next));
                }
                ++i;
            }
        }

        private IPath getPath(IResource resource) {
            IPath prPath = resource.getFullPath();
            Assert.isLegal((boolean)this.myRoot.isPrefixOf(prPath));
            return prPath.removeFirstSegments(this.myRoot.segmentCount());
        }

        private Entity copyOrCut(Entity e) {
            if (this.myIsCutting) {
                return e.cut();
            }
            return e.copy();
        }

        private Entity getAssembledJSP(Servlet s, IFile jspFile) {
            Model webAppModel = ModelAccess.getModel((UniqueName)ModelUinSupport.createModelUin((IResource)s.getDocument().getFile()));
            return webAppModel.findEntity(this.getJsp(WebContentCopyPasteProvider.this.getModel(), WebModelMetaInfo.getJSPUniqueName(jspFile), this.getWebAppUin(s.getDocument().getFile()), s.getName()));
        }

        public UniqueName getJsp(Model jspModel, UniqueName jspUin, UniqueName webAppUin, String name) {
            name = UinEscaper.escape((String)name);
            return ProxyMetaInfo.getProxyUniqueName((UniqueName)webAppUin, (UniqueName)jspModel.getUniqueName(), (UniqueName)jspUin, (String[])new String[]{name});
        }

        public UniqueName getWebAppUin(IFile file) {
            String fileName = UinEscaper.escape((String)file.getProjectRelativePath().toString());
            return ModelAccess.createUniqueName((String)"com.tssap.j2ee.core.webapp", (String)"com.tssap.j2ee.core.webapp.WebApp", (String)fileName, (String)fileName, null);
        }

        private ParametrizedHashBag getAssembledServletCopies(IPath path2jsp) {
            ParametrizedHashBag result = (ParametrizedHashBag)this.myJSPs2AssembledServletCopies.get(path2jsp);
            if (result == null) {
                result = new ParametrizedHashBag(class$java$util$ArrayList == null ? (class$java$util$ArrayList = CopyingVisitor.class$("java.util.ArrayList")) : class$java$util$ArrayList);
                this.myJSPs2AssembledServletCopies.put(path2jsp, result);
            }
            return result;
        }

        public void delete() {
            this.myContents = null;
            Iterator it = this.myJSPs2AssembledServletCopies.values().iterator();
            while (it.hasNext()) {
                ParametrizedHashBag next = (ParametrizedHashBag)it.next();
                Iterator it2 = next.keyIterator();
                while (it2.hasNext()) {
                    Entity parent = (Entity)it2.next();
                    Collection list = next.safeGet((Object)parent);
                    Iterator it3 = list.iterator();
                    while (it3.hasNext()) {
                        Entity copiedEntity = (Entity)it3.next();
                        copiedEntity.delete();
                    }
                }
            }
        }

        public boolean canPaste(IFolder container) {
            return true;
        }

        public IResource paste(IFolder container) {
            String newName = this.getUnusedName(container);
            if (newName == null) {
                return null;
            }
            IPath newPath = container.getFullPath().append(newName);
            HashMap<IPath, IPath> oldJSPPaths2NewJSPPaths = new HashMap<IPath, IPath>();
            Iterator it = this.myContents.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                IPath rootRelativePath = (IPath)next.getKey();
                byte[] contents = (byte[])next.getValue();
                IPath fullPathToFile = newPath.append(rootRelativePath);
                String fileName = fullPathToFile.lastSegment();
                IPath containerPath = fullPathToFile.removeLastSegments(1);
                try {
                    FileUtils.createFile((IPath)containerPath, (String)fileName, (InputStream)new ByteArrayInputStream(contents), (IProgressMonitor)new NullProgressMonitor());
                    oldJSPPaths2NewJSPPaths.put(rootRelativePath, fullPathToFile);
                }
                catch (CoreException e) {
                    WebPlugin.logError("Could not paste contents of file " + fullPathToFile, e);
                }
            }
            Iterator it2 = this.myJSPs2AssembledServletCopies.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry nextEntry = it2.next();
                IPath nextPath = (IPath)nextEntry.getKey();
                IPath newFullPath = (IPath)oldJSPPaths2NewJSPPaths.get(nextPath);
                if (newFullPath == null) continue;
                IPath newProjectRelativePath = newFullPath.removeFirstSegments(1);
                String newJSPLocation = newProjectRelativePath.toString();
                ParametrizedHashBag next = (ParametrizedHashBag)nextEntry.getValue();
                Iterator it22 = next.keyIterator();
                while (it22.hasNext()) {
                    Entity parent = (Entity)it22.next();
                    Collection list = next.safeGet((Object)parent);
                    Iterator it3 = list.iterator();
                    while (it3.hasNext()) {
                        Entity copiedEntity = (Entity)it3.next();
                        ClipboardElement clipboardEntity = ModelClipboard.getElement((CopyUniqueName)((CopyUniqueName)copiedEntity.getUniqueName()));
                        clipboardEntity.setPropertyValue("jspFileRef", newJSPLocation);
                        if (parent.canPaste((Element)copiedEntity)) {
                            parent.paste((Element)copiedEntity);
                            continue;
                        }
                        WebPlugin.logError("Could not paste copied JSP");
                    }
                }
            }
            IWorkspaceRoot wsRoot = container.getWorkspace().getRoot();
            Iterator it3 = this.myFolders.iterator();
            while (it3.hasNext()) {
                IPath nextFolder = (IPath)it3.next();
                IPath fullPath = newPath.append(nextFolder);
                IFolder res = wsRoot.getFolder(fullPath);
                if (res.exists()) continue;
                try {
                    FileUtils.createFolder((IContainer)res, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    WebPlugin.logError("Could not paste folder " + fullPath, e);
                }
            }
            return container.findMember(newName);
        }

        private String getUnusedName(IFolder container) {
            int startingNumber;
            int lastChar;
            String lastSegment = this.myRoot.lastSegment();
            if (container.findMember(lastSegment) == null) {
                return lastSegment;
            }
            String extension = this.myRoot.getFileExtension();
            extension = extension == null ? "" : '.' + extension;
            String fileName = this.myRoot.removeFileExtension().lastSegment();
            int lastDigit = lastChar = fileName.length() - 1;
            while (lastDigit > 0 && Character.isDigit(fileName.charAt(lastDigit))) {
                --lastDigit;
            }
            ++lastDigit;
            while (lastDigit < lastChar && fileName.charAt(lastDigit) == '0') {
                ++lastDigit;
            }
            if (lastDigit <= lastChar) {
                String trailingDigits = fileName.substring(lastDigit);
                try {
                    startingNumber = Integer.parseInt(trailingDigits);
                    fileName = fileName.substring(0, lastDigit);
                }
                catch (NumberFormatException e) {
                    startingNumber = 1;
                }
            } else {
                startingNumber = 1;
            }
            int i = startingNumber;
            while (i < Integer.MAX_VALUE) {
                if (container.findMember(fileName + i + extension) == null) {
                    return fileName + i + extension;
                }
                ++i;
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

