/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.utils.JdtModelUtils;
import com.tssap.j2ee.core.web.GenericServletCreationOptions;
import com.tssap.j2ee.core.web.HttpServletCreationOptions;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;

public class ServletProvider
extends AbstractWebProvider
implements EntityExistenceProvider {
    public boolean exists(UniqueName uniqueName) {
        IServlet servlet = this.getServlet(uniqueName);
        return servlet != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.web.Servlet".equals(shapeType)) {
            return false;
        }
        return JdtModelUtils.isWritablePackage((Element)parent);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String packageName = parent.getPropertyValue("$fullName");
        String name = null;
        if (template == null) {
            template = parent.getModel().createEntityTemplate();
        }
        name = template.getPropertyValue("$name");
        if (template.hasProperty("httpServlet")) {
            return this.createHttpServletUniqueName(packageName, name, template);
        }
        return this.createGenericServletUniqueName(packageName, name, template);
    }

    private UniqueName createHttpServletUniqueName(String packageName, String name, Entity template) {
        IServlet servlet;
        HttpServletCreationOptions options = new HttpServletCreationOptions();
        options.setCreateDoGet(template.hasProperty("doGet"));
        options.setCreateDoPost(template.hasProperty("doPost"));
        options.setCreateDoHead(template.hasProperty("doHead"));
        options.setCreateDoPut(template.hasProperty("doPut"));
        options.setCreateDoDelete(template.hasProperty("doDelete"));
        options.setCreateDoOptions(template.hasProperty("doOptions"));
        options.setCreateDoTrace(template.hasProperty("doTrace"));
        options.setCreateService(template.hasProperty("service"));
        options.setCreateInit(template.hasProperty("init"));
        options.setCreateDestroy(template.hasProperty("destroy"));
        options.setSingleThreaded(template.hasProperty("singleThreaded"));
        try {
            servlet = this.getProject().createHttpServlet(packageName, name, options, null);
        }
        catch (WebModelException e) {
            return null;
        }
        return WebModelMetaInfo.getUniqueName(servlet);
    }

    private UniqueName createGenericServletUniqueName(String packageName, String name, Entity template) {
        IServlet servlet;
        GenericServletCreationOptions options = new GenericServletCreationOptions();
        options.setCreateInit(template.hasProperty("init"));
        options.setCreateDestroy(template.hasProperty("destroy"));
        options.setSingleThreaded(template.hasProperty("singleThreaded"));
        try {
            servlet = this.getProject().createServlet(packageName, name, options, null);
        }
        catch (WebModelException e) {
            return null;
        }
        return WebModelMetaInfo.getUniqueName(servlet);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return WebModelMetaInfo.isServletUniqueName(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        return !this.isDeleted(element);
    }

    public void delete(Element element) {
        IServlet servlet = this.getServlet(element.getUniqueName());
        try {
            servlet.delete(null);
        }
        catch (WebModelException e) {
            e.printStackTrace();
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }
}

