/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.WebModelException;
import com.tssap.j2ee.internal.core.providers.web.AbstractPropertyReader;
import com.tssap.j2ee.internal.core.providers.web.WebPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class NameProvider
extends AbstractPropertyReader
implements PropertyUniqueNameProvider {
    public NameProvider() {
        this.addPropertyName("$name");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IResource resource;
        UniqueName elementUin = element.getUniqueName();
        if (WebModelMetaInfo.isJSPUniqueName(elementUin)) {
            IJSP jsp = this.getJSP(elementUin);
            if (jsp == null) {
                return null;
            }
            IFile jspFile = jsp.getFile();
            if (jspFile == null) {
                return null;
            }
            String name = jspFile.getName();
            if (name.endsWith("jsp")) {
                name = name.substring(0, name.length() - "jsp".length() - 1);
            }
            return name;
        }
        if ("com.tssap.j2ee.core.web.HTML".equals(element.getPropertyValue("$metaclass"))) {
            String name = element.getUniqueName().getName();
            if (name.endsWith("htm")) {
                name = name.substring(0, name.length() - "htm".length() - 1);
            } else if (name.endsWith("html")) {
                name = name.substring(0, name.length() - "html".length() - 1);
            }
            return name;
        }
        if ("com.tssap.j2ee.core.web.Resource".equals(element.getPropertyValue("$metaclass")) && (resource = (IResource)element.getObjectPropertyValue("FileAndFolderDataSource")) != null) {
            String name = resource.getName();
            String extension = resource.getFileExtension();
            if (extension == null) {
                return name;
            }
            name = name.substring(0, name.length() - extension.length() - 1);
            return name;
        }
        return element.getUniqueName().getName();
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        ISourceWebElement sourceWebElement = this.getSourceWebElement(element.getUniqueName());
        return sourceWebElement != null && sourceWebElement.canSetName(propertyValue);
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        String metaclass = element.getPropertyValue("$metaclass");
        ISourceWebElement sourceWebElement = this.getSourceWebElement(element.getUniqueName());
        try {
            String fqn = sourceWebElement.setName(propertyValue);
            return WebModelMetaInfo.getSourceElementUniqueName(fqn, metaclass);
        }
        catch (WebModelException e) {
            WebPlugin.logError("Failed to set name", e);
            return null;
        }
    }
}

