/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.web.WebProject;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootCopyPaster;
import com.tssap.selena.model.providers.resources.IRootProvider;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JspRootProvider
implements IRootProvider {
    private WebProject myWebProject;
    private IFolder myRoot;
    private static final String JSP_ROOT_ID = "com.tssap.j2ee.core.web.jsp_root";
    private static final String WEB_CONTENT_PATH = "webContent";

    public JspRootProvider(WebProject project) {
        this.myWebProject = project;
        this.myRoot = this.myWebProject.getProject().getFolder(WEB_CONTENT_PATH);
    }

    public void registered(IProject project) {
        Assert.isLegal((boolean)project.getName().equals(this.myWebProject.getProject().getName()));
    }

    public void unregistered(IProject project) {
        Assert.isLegal((boolean)project.getName().equals(this.myWebProject.getProject().getName()));
    }

    public String getID() {
        return JSP_ROOT_ID;
    }

    public IPath getRootPath() {
        return new Path("");
    }

    public boolean isValidFolder(IProjectRelativePath path) {
        if (!this.myRoot.exists()) {
            return false;
        }
        if (path.segmentCount() == 0) {
            return true;
        }
        IPath rootPath = this.myRoot.getProjectRelativePath();
        return rootPath.isPrefixOf((IPath)path);
    }

    public IRootProvider.ConsistencyType shouldBeConsistent() {
        return IRootProvider.ConsistencyType.FULL;
    }

    public boolean canRename(IProjectRelativePath fromPath, IProjectRelativePath destPath) {
        return false;
    }

    public boolean rename(IProjectRelativePath fromPath, IProjectRelativePath destPath) {
        return false;
    }

    public IRootCopyPaster getCopyPaster() {
        return IRootCopyPaster.NULL_COPY_PASTER;
    }
}

