/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.core.providers.web.WebModelMetaInfo;
import com.tssap.j2ee.core.web.IAbstractServlet;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionActivationListener;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IHttpSessionBindingListener;
import com.tssap.j2ee.core.web.IHttpSessionListener;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IServletContextAttributeListener;
import com.tssap.j2ee.core.web.IServletContextListener;
import com.tssap.j2ee.core.web.ISourceWebElement;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.IWebMethodContainer;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.Provider;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class AbstractWebProvider
implements Provider,
ModelAware {
    private Model myModel;
    private WebProject myProject;
    private static final UniqueName REF_PROJECTS_UIN = NameUtil.getRootUniqueName((String)"ref");

    public void registered(Model model) {
        this.myModel = model;
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        this.myProject = WebProject.getInstance((IProject)project);
    }

    public void unregistered(Model model) {
        this.myModel = null;
        this.myProject = null;
    }

    public Model getModel() {
        return this.myModel;
    }

    public WebProject getProject() {
        return this.myProject;
    }

    public IServlet getServlet(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isServletUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getServlet(this.getFQN(packageName, name));
    }

    public IFilter getFilter(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isFilterUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getFilter(this.getFQN(packageName, name));
    }

    public IHttpSessionAttributeListener getHttpSessionAttributeListener(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isHttpSessionAttributeListenerUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getHttpSessionAttributeListener(this.getFQN(packageName, name));
    }

    public IHttpSessionActivationListener getHttpSessionActivationListener(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isHttpSessionActivationListenerUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getHttpSessionActivationListener(this.getFQN(packageName, name));
    }

    public IHttpSessionBindingListener getHttpSessionBindingListener(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isHttpSessionBindingListenerUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getHttpSessionBindingListener(this.getFQN(packageName, name));
    }

    public IHttpSessionListener getHttpSessionListener(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isHttpSessionListenerUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getHttpSessionListener(this.getFQN(packageName, name));
    }

    public IServletContextAttributeListener getServletContextAttributeListener(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isServletContextAttributeListenerUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getServletContextAttributeListener(this.getFQN(packageName, name));
    }

    public IServletContextListener getServletContextListener(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isServletContextListenerUniqueName(uniqueName)) {
            return null;
        }
        String packageName = uniqueName.getLocation();
        String name = uniqueName.getName();
        return this.myProject.getServletContextListener(this.getFQN(packageName, name));
    }

    protected ISourceWebElement getSourceWebElement(UniqueName uniqueName) {
        if (WebModelMetaInfo.isFilterUniqueName(uniqueName)) {
            return this.getFilter(uniqueName);
        }
        if (WebModelMetaInfo.isHttpSessionAttributeListenerUniqueName(uniqueName)) {
            return this.getHttpSessionAttributeListener(uniqueName);
        }
        if (WebModelMetaInfo.isHttpSessionActivationListenerUniqueName(uniqueName)) {
            return this.getHttpSessionActivationListener(uniqueName);
        }
        if (WebModelMetaInfo.isHttpSessionBindingListenerUniqueName(uniqueName)) {
            return this.getHttpSessionBindingListener(uniqueName);
        }
        if (WebModelMetaInfo.isHttpSessionListenerUniqueName(uniqueName)) {
            return this.getHttpSessionListener(uniqueName);
        }
        if (WebModelMetaInfo.isServletContextAttributeListenerUniqueName(uniqueName)) {
            return this.getServletContextAttributeListener(uniqueName);
        }
        if (WebModelMetaInfo.isServletContextListenerUniqueName(uniqueName)) {
            return this.getServletContextListener(uniqueName);
        }
        if (WebModelMetaInfo.isServletUniqueName(uniqueName)) {
            return this.getServlet(uniqueName);
        }
        return null;
    }

    public IJSP getJSP(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isJSPUniqueName(uniqueName)) {
            return null;
        }
        String projectName = uniqueName.getLocation();
        String projectRelativePath = uniqueName.getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.isAccessible()) {
            return null;
        }
        IResource shouldBeFile = project.findMember(projectRelativePath);
        if (shouldBeFile == null || shouldBeFile.getType() != 1) {
            return null;
        }
        return this.getProject().getJSP((IFile)shouldBeFile);
    }

    IResource getResource(Element element) {
        UniqueName elementUin = element.getUniqueName();
        return this.getResource(elementUin);
    }

    IResource getResource(UniqueName elementUin) {
        if (WebModelMetaInfo.isJSPUniqueName(elementUin)) {
            IJSP jsp = this.getJSP(elementUin);
            if (jsp == null) {
                return null;
            }
            return jsp.getFile();
        }
        Path elementPath = new Path(elementUin.getLocation());
        if ("jsp".equals(elementPath.getFileExtension())) {
            return null;
        }
        if (elementPath.segmentCount() < 2 || !"webContent".equals(elementPath.segment(1))) {
            return null;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)elementPath)) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)elementPath);
            return resource;
        }
        return null;
    }

    protected UniqueName getParentUniqueName(IWebElement element) {
        if (element instanceof ISourceWebElement) {
            IType type = ((ISourceWebElement)element).getType();
            if (type != null) {
                IPackageFragment fragment = type.getPackageFragment();
                return NameUtil.getJavaElementUniqueName((IJavaProject)this.getJavaProject(), (IJavaElement)fragment);
            }
            String beanPackage = AbstractWebProvider.getPackageName(((ISourceWebElement)element).getTypeName());
            beanPackage = beanPackage.replace('.', '/');
            return RootManagerAccess.getRootManager((IProject)this.getProject().getProject()).getUniqueName((IRootRelativePath)RootRelativePath.valueOf((String)beanPackage));
        }
        if (element instanceof IJSP) {
            IFile file = ((IJSP)element).getFile();
            if (!ModelUinSupport.createModelUin((IResource)file).equals(this.getModel().getUniqueName())) {
                return REF_PROJECTS_UIN;
            }
            return RootManagerAccess.getRootManager((IProject)this.getProject().getProject()).getUniqueName((IRootRelativePath)RootRelativePath.valueOf((IPath)file.getParent().getProjectRelativePath()));
        }
        if (element instanceof WebProject) {
            return null;
        }
        if (element instanceof IWebMethod) {
            return WebModelMetaInfo.getUniqueName(element.getParent());
        }
        return null;
    }

    private static String getPackageName(String typeFQN) {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        return lastDotIndex == -1 ? "" : typeFQN.substring(0, lastDotIndex);
    }

    private String getFQN(String packageName, String className) {
        if (packageName.length() == 0) {
            return className;
        }
        return packageName + '.' + className;
    }

    protected IJavaProject getJavaProject() {
        return this.myProject.getJavaProject();
    }

    protected IAbstractServlet getAbstractServlet(UniqueName uniqueName) {
        IServlet result = this.getServlet(uniqueName);
        if (result != null) {
            return result;
        }
        result = this.getJSP(uniqueName);
        return result;
    }

    protected IWebMethodContainer getWebMethodContainer(UniqueName uniqueName) {
        IServlet result = this.getServlet(uniqueName);
        if (result != null) {
            return result;
        }
        result = this.getFilter(uniqueName);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected IWebMethod getWebMethod(UniqueName uniqueName) {
        if (!WebModelMetaInfo.isWebMethodUniqueName(uniqueName)) {
            return null;
        }
        IWebMethod servletMethod = this.getServletMethod(uniqueName);
        if (servletMethod != null) {
            return servletMethod;
        }
        IWebMethod filterMethod = this.getFilterMethod(uniqueName);
        if (filterMethod != null) {
            return filterMethod;
        }
        return null;
    }

    private IWebMethod getServletMethod(UniqueName uniqueName) {
        String servletFQN = uniqueName.getLocation();
        IServlet servlet = this.myProject.getServlet(servletFQN);
        if (servlet == null) {
            return null;
        }
        String name = uniqueName.getName();
        return servlet.getMethod(name);
    }

    private IWebMethod getFilterMethod(UniqueName uniqueName) {
        String filterFQN = uniqueName.getLocation();
        IFilter filter = this.myProject.getFilter(filterFQN);
        if (filter == null) {
            return null;
        }
        String name = uniqueName.getName();
        return filter.getMethod(name);
    }
}

