/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.web;

import com.tssap.j2ee.internal.core.providers.web.AbstractWebProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.enum.SequenceEnumeration;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractPropertyReader
extends AbstractWebProvider
implements PropertyGetProvider {
    private HashSet myPropertyNames = new HashSet();

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        PropertyEnumeration result = EmptyEnumeration.getPropertyEnumeration();
        Iterator it = this.myPropertyNames.iterator();
        while (it.hasNext()) {
            result = new SequenceEnumeration((Enumeration)result, (Enumeration)this.properties(element, (String)it.next()));
        }
        return EnumerationConverter.toPropertyEnumeration((Enumeration)result);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        if (property == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        return SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue != null && propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    protected void addPropertyName(String name) {
        this.myPropertyNames.add(name);
    }

    public abstract String getPropertyValue(Element var1, String var2);
}

